/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.machat.commands;

import com.maciej916.machat.classes.RulesData;
import com.maciej916.machat.config.ConfigValues;
import com.maciej916.machat.data.DataManager;
import com.maciej916.machat.libs.Methods;
import com.maciej916.machat.libs.text.TextFormat;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class CommandRules {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"rules").requires(source -> source.func_197034_c(0));
        ((LiteralArgumentBuilder)builder.executes(context -> CommandRules.rules((CommandContext<CommandSource>)context))).then(Commands.func_197056_a((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(context -> CommandRules.rulesPage((CommandContext<CommandSource>)context)));
        dispatcher.register(builder);
    }

    private static int rules(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        CommandRules.showRules(player, 1);
        return 1;
    }

    private static int rulesPage(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        int page = IntegerArgumentType.getInteger(context, (String)"page");
        CommandRules.showRules(player, page);
        return 1;
    }

    public static ArrayList<Object> replacePage(ArrayList<Object> var, int page, int maxPages) {
        ArrayList<String> replace = new ArrayList<String>();
        ArrayList<Object> replaceWith = new ArrayList<Object>();
        replace.add("page");
        replaceWith.add(new StringTextComponent(String.valueOf(page)));
        replace.add("max_pages");
        replaceWith.add(new StringTextComponent(String.valueOf(maxPages)));
        return TextFormat.variableReplacer(var, replace, replaceWith);
    }

    public static ArrayList<Object> replaceRule(ArrayList<Object> var, int id, String rule) {
        ArrayList<String> replace = new ArrayList<String>();
        ArrayList<Object> replaceWith = new ArrayList<Object>();
        replace.add("id");
        replaceWith.add(new StringTextComponent(String.valueOf(id + 1)));
        replace.add("rule");
        replaceWith.add(new StringTextComponent(TextFormat.replaceColors(rule)));
        return TextFormat.variableReplacer(var, replace, replaceWith);
    }

    private static void showRules(ServerPlayerEntity player, int page) {
        RulesData rules = DataManager.getRules();
        int rulesCount = rules.rulesList().size();
        int rulesPerPage = ConfigValues.rules_per_page;
        int minPage = page * rulesPerPage - rulesPerPage;
        int maxPage = Math.min(page * rulesPerPage, rulesCount);
        int maxPages = (int)Math.ceil((double)rulesCount / (double)rulesPerPage);
        if (page > maxPages) {
            player.func_145747_a((ITextComponent)Methods.formatText("rules.machat.not_exist", new Object[0]));
            return;
        }
        ArrayList<Object> var = TextFormat.variableFinder(rules.format_top, true);
        var = CommandRules.replacePage(var, page, maxPages);
        player.func_145747_a((ITextComponent)TextFormat.componentBuilder(var));
        for (int i = minPage; i < maxPage; ++i) {
            var = TextFormat.variableFinder(rules.format_rule, true);
            var = CommandRules.replaceRule(var, i, rules.rulesList().get(i));
            player.func_145747_a((ITextComponent)TextFormat.componentBuilder(var));
        }
        var = TextFormat.variableFinder(rules.format_bottom, true);
        var = CommandRules.replacePage(var, page, maxPages);
        player.func_145747_a((ITextComponent)TextFormat.componentBuilder(var));
    }
}

