/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.machat.data;

import com.google.gson.Gson;
import com.maciej916.machat.classes.ChatData;
import com.maciej916.machat.classes.MessagesData;
import com.maciej916.machat.classes.RulesData;
import com.maciej916.machat.config.ConfigValues;
import com.maciej916.machat.data.DataManager;
import com.maciej916.machat.libs.Log;
import com.maciej916.machat.libs.Methods;
import java.io.File;
import java.io.Reader;

public class DataLoader {
    public static void setupMain() {
        Log.log("Setup main catalog");
        ConfigValues.mainCatalog = System.getProperty("user.dir") + "/" + "ma-chat" + "/";
        Log.debug("Main catalog is: " + ConfigValues.mainCatalog);
        try {
            Log.log("Creating main catalogs and files");
            new File(ConfigValues.mainCatalog).mkdirs();
            Methods.writeModFile("motd.txt", ConfigValues.mainCatalog + "motd.txt");
            Methods.writeModFile("rules.json", ConfigValues.mainCatalog + "rules.json");
            Methods.writeModFile("chat.json", ConfigValues.mainCatalog + "chat.json");
            Methods.writeModFile("messages.json", ConfigValues.mainCatalog + "messages.json");
        }
        catch (Exception e) {
            Log.err("Error in setupMain");
            throw new Error(e);
        }
    }

    public static void load() {
        Log.log("Loading data");
        try {
            Log.debug("Clean data");
            DataManager.cleanData();
            Log.debug("Loading chat...");
            DataLoader.loadChat();
            Log.debug("Loading rules...");
            DataLoader.loadRules();
            Log.debug("Loading messages...");
            DataLoader.loadMessages();
            Log.log("Data loaded");
        }
        catch (Exception e) {
            Log.err("Error while loading data!");
            throw new Error(e);
        }
    }

    private static void loadChat() throws Exception {
        ChatData data = (ChatData)new Gson().fromJson((Reader)Methods.loadFile(ConfigValues.mainCatalog, "chat"), ChatData.class);
        DataManager.setChat(data);
    }

    private static void loadRules() throws Exception {
        RulesData data = (RulesData)new Gson().fromJson((Reader)Methods.loadFile(ConfigValues.mainCatalog, "rules"), RulesData.class);
        DataManager.setRules(data);
    }

    private static void loadMessages() throws Exception {
        MessagesData data = (MessagesData)new Gson().fromJson((Reader)Methods.loadFile(ConfigValues.mainCatalog, "messages"), MessagesData.class);
        DataManager.setMessages(data);
    }
}

