/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.machat.libs.auto_message;

import com.maciej916.machat.config.ConfigValues;
import com.maciej916.machat.data.DataManager;
import com.maciej916.machat.libs.Log;
import com.maciej916.machat.libs.auto_message.AutoMessageTask;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.server.MinecraftServer;

public class AutoMessage {
    private Timer timer;
    private MinecraftServer server;

    public AutoMessage(MinecraftServer server) {
        this.server = server;
    }

    public void startTimer() {
        boolean dedicated = this.server.func_71262_S();
        if (dedicated || !dedicated && ConfigValues.client_enable) {
            this.timer = new Timer();
            AutoMessageTask task = new AutoMessageTask(this.server);
            int frequency = DataManager.getMessages().getFrequency();
            if (frequency < 5000) {
                Log.debug("Auto Message frequency is too small. Changed to 5 seconds.");
                DataManager.getMessages().setFrequency(5000);
                frequency = 5000;
            }
            this.timer.schedule((TimerTask)task, frequency, (long)frequency);
        }
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void restartTimer() {
        this.stopTimer();
        this.startTimer();
    }
}

