/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import journeymap.client.model.BlockDataArrays;
import journeymap.client.model.BlockFlag;
import journeymap.client.model.BlockMD;
import journeymap.client.model.MapType;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.Journeymap;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.gen.Heightmap;

public class ChunkMD {
    public static final String PROP_IS_SLIME_CHUNK = "isSlimeChunk";
    public static final String PROP_LOADED = "loaded";
    public static final String PROP_LAST_RENDERED = "lastRendered";
    private final WeakReference<Chunk> chunkReference;
    private final ChunkPos coord;
    private final HashMap<String, Serializable> properties = new HashMap();
    private BlockDataArrays blockDataArrays = new BlockDataArrays();
    private final Random random;
    private Chunk retainedChunk;

    public ChunkMD(Chunk chunk) {
        this(chunk, false);
    }

    public ChunkMD(Chunk chunk, boolean forceRetain) {
        if (chunk == null) {
            throw new IllegalArgumentException("Chunk can't be null");
        }
        this.random = new Random();
        this.coord = new ChunkPos(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        this.setProperty(PROP_LOADED, Long.valueOf(System.currentTimeMillis()));
        this.properties.put(PROP_IS_SLIME_CHUNK, Boolean.valueOf(ChunkMD.isSlimeChunk(chunk)));
        this.chunkReference = new WeakReference<Chunk>(chunk);
        if (forceRetain) {
            this.retainedChunk = chunk;
        }
    }

    public BlockState getBlockState(int localX, int y, int localZ) {
        if (localX < 0 || localX > 15 || localZ < 0 || localZ > 15) {
            Journeymap.getLogger().warn("Expected local coords, got global coords");
        }
        return this.getBlockState(new BlockPos(this.toWorldX(localX), y, this.toWorldZ(localZ)));
    }

    public BlockState getBlockState(BlockPos blockPos) {
        return JmBlockAccess.INSTANCE.func_180495_p(blockPos);
    }

    public BlockMD getBlockMD(BlockPos blockPos) {
        return BlockMD.getBlockMD(this, blockPos);
    }

    @Nullable
    public Biome getBiome(BlockPos pos) {
        Chunk chunk = this.getChunk();
        return Minecraft.func_71410_x().field_71441_e.func_225523_d_().func_226836_a_(pos);
    }

    public int getSavedLightValue(int localX, int y, int localZ) {
        try {
            return this.getChunk().func_217307_e().func_227470_b_(this.getBlockPos(localX, y, localZ), LightType.BLOCK.field_77198_c);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1;
        }
    }

    public final BlockMD getBlockMD(int localX, int y, int localZ) {
        return BlockMD.getBlockMD(this, this.getBlockPos(localX, y, localZ));
    }

    public int ceiling(int localX, int localZ) {
        int chunkHeight;
        int y = chunkHeight = this.getPrecipitationHeight(this.getBlockPos(localX, 0, localZ));
        BlockPos blockPos = null;
        try {
            Chunk chunk = this.getChunk();
            while (y >= 0) {
                blockPos = this.getBlockPos(localX, y, localZ);
                BlockMD blockMD = this.getBlockMD(blockPos);
                if (blockMD == null) {
                    --y;
                    continue;
                }
                if (blockMD.isIgnore() || blockMD.hasFlag(BlockFlag.OpenToSky)) {
                    --y;
                    continue;
                }
                if (this.canBlockSeeTheSky(localX, y, localZ)) {
                    --y;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(e + " at " + blockPos, (Throwable)e);
        }
        return Math.max(0, y);
    }

    public boolean hasChunk() {
        Chunk chunk = (Chunk)this.chunkReference.get();
        boolean result = chunk != null && !(chunk instanceof EmptyChunk) && chunk.field_76636_d;
        return result;
    }

    public int getHeight(BlockPos blockPos) {
        Chunk chunk = this.getChunk();
        return ((Heightmap)chunk.field_76634_f.get(Heightmap.Type.WORLD_SURFACE)).func_202273_a(blockPos.func_177958_n(), blockPos.func_177952_p());
    }

    public int getPrecipitationHeight(int localX, int localZ) {
        return this.getPrecipitationHeight(this.getBlockPos(localX, 0, localZ));
    }

    public int getPrecipitationHeight(BlockPos blockPos) {
        return this.getChunk().func_201576_a(Heightmap.Type.WORLD_SURFACE, blockPos.func_177958_n(), blockPos.func_177952_p());
    }

    public int getLightOpacity(BlockMD blockMD, int localX, int y, int localZ) {
        BlockPos pos = this.getBlockPos(localX, y, localZ);
        return blockMD.getBlockState().func_177230_c().func_200011_d(blockMD.getBlockState(), (IBlockReader)JmBlockAccess.INSTANCE, pos);
    }

    public Serializable getProperty(String name) {
        return this.properties.get(name);
    }

    public Serializable getProperty(String name, Serializable defaultValue) {
        Serializable currentValue = this.getProperty(name);
        if (currentValue == null) {
            this.setProperty(name, defaultValue);
            currentValue = defaultValue;
        }
        return currentValue;
    }

    public Serializable setProperty(String name, Serializable value) {
        return this.properties.put(name, value);
    }

    public int hashCode() {
        return this.getCoord().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkMD other = (ChunkMD)obj;
        return this.getCoord().equals((Object)other.getCoord());
    }

    public Chunk getChunk() {
        Chunk chunk = (Chunk)this.chunkReference.get();
        if (chunk == null) {
            throw new ChunkMissingException(this.getCoord());
        }
        return chunk;
    }

    public ClientWorld getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public int getWorldActualHeight() {
        return this.getWorld().func_72940_L() + 1;
    }

    public Boolean hasNoSky() {
        return !this.getWorld().field_73011_w.func_76569_d();
    }

    public boolean canBlockSeeTheSky(int localX, int y, int localZ) {
        int i = localX & 0xF;
        int k = localZ & 0xF;
        return y >= ((Heightmap)this.getChunk().field_76634_f.get(Heightmap.Type.WORLD_SURFACE)).func_202273_a(i, k);
    }

    public ChunkPos getCoord() {
        return this.coord;
    }

    public static boolean isSlimeChunk(Chunk chunk) {
        return SharedSeedRandom.func_205190_a((int)chunk.func_76632_l().field_77276_a, (int)chunk.func_76632_l().field_77275_b, (long)chunk.func_177412_p().func_72905_C(), (long)987234911L).nextInt(10) == 0;
    }

    public long getLoaded() {
        return (Long)this.getProperty(PROP_LOADED, Long.valueOf(0L));
    }

    public void resetRenderTimes() {
        this.getRenderTimes().clear();
    }

    public void resetRenderTime(MapType mapType) {
        this.getRenderTimes().put(mapType, 0L);
    }

    public void resetBlockData(MapType mapType) {
        this.getBlockData().get(mapType).clear();
    }

    protected HashMap<MapType, Long> getRenderTimes() {
        HashMap obj = this.properties.get(PROP_LAST_RENDERED);
        if (!(obj instanceof HashMap)) {
            obj = new HashMap();
            this.properties.put(PROP_LAST_RENDERED, obj);
        }
        return obj;
    }

    public long getLastRendered(MapType mapType) {
        return this.getRenderTimes().getOrDefault(mapType, 0L);
    }

    public long setRendered(MapType mapType) {
        long now = System.currentTimeMillis();
        this.getRenderTimes().put(mapType, now);
        return now;
    }

    public BlockPos getBlockPos(int localX, int y, int localZ) {
        return new BlockPos(this.toWorldX(localX), y, this.toWorldZ(localZ));
    }

    public int toWorldX(int localX) {
        return (this.coord.field_77276_a << 4) + localX;
    }

    public int toWorldZ(int localZ) {
        return (this.coord.field_77275_b << 4) + localZ;
    }

    public BlockDataArrays getBlockData() {
        return this.blockDataArrays;
    }

    public BlockDataArrays.DataArray<Integer> getBlockDataInts(MapType mapType) {
        return this.blockDataArrays.get(mapType).ints();
    }

    public BlockDataArrays.DataArray<Float> getBlockDataFloats(MapType mapType) {
        return this.blockDataArrays.get(mapType).floats();
    }

    public BlockDataArrays.DataArray<Boolean> getBlockDataBooleans(MapType mapType) {
        return this.blockDataArrays.get(mapType).booleans();
    }

    public String toString() {
        return "ChunkMD{coord=" + this.coord + ", properties=" + this.properties + '}';
    }

    public int getDimension() {
        return this.getWorld().func_201675_m().func_186058_p().func_186068_a();
    }

    public void stopChunkRetention() {
        this.retainedChunk = null;
    }

    public boolean hasRetainedChunk() {
        return this.retainedChunk != null;
    }

    protected void finalize() throws Throwable {
        if (this.retainedChunk != null) {
            super.finalize();
        }
    }

    public static class ChunkMissingException
    extends RuntimeException {
        ChunkMissingException(ChunkPos coord) {
            super("Chunk missing: " + coord);
        }
    }
}

