/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import journeymap.client.ui.component.BooleanPropertyButton;
import journeymap.common.properties.config.BooleanField;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class CheckBox
extends BooleanPropertyButton {
    public int boxWidth = 11;
    String glyph = "\u2714";

    public CheckBox(String label, boolean checked, Button.IPressable pressable) {
        this(label, null, pressable);
        this.toggled = checked;
    }

    public CheckBox(String label, BooleanField field, Button.IPressable pressable) {
        super(label, label, field, pressable);
        this.fontRenderer.getClass();
        this.setHeight(9 + 2);
        this.setWidth(this.getFitWidth(this.fontRenderer));
    }

    public CheckBox(String label, boolean checked) {
        this(label, checked, CheckBox.emptyPressable());
    }

    public CheckBox(String label, BooleanField field) {
        this(label, field, CheckBox.emptyPressable());
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        return super.getFitWidth(fr) + this.boxWidth + 2;
    }

    @Override
    public void render(int mouseX, int mouseY, float ticks) {
        if (this.visible) {
            this.setHovered(this.isEnabled() && mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height);
            int yoffset = (this.height - this.boxWidth) / 2;
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS_LOCATION, (int)this.x, (int)(this.y + yoffset), (int)0, (int)46, (int)this.boxWidth, (int)this.boxWidth, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.getBlitOffset());
            this.mouseDragged(mouseX, mouseY, 0, this.x, this.y);
            int color = 0xE0E0E0;
            if (this.isHovered()) {
                color = 0xFFFFA0;
            } else if (!this.isEnabled()) {
                color = 0x404040;
            } else if (this.labelColor != null) {
                color = this.labelColor;
            } else if (this.packedFGColor != 0) {
                color = this.packedFGColor;
            }
            int labelPad = 4;
            if (this.toggled.booleanValue()) {
                this.drawCenteredString(this.fontRenderer, this.glyph, this.x + this.boxWidth / 2 + 1, this.y + 1 + yoffset, color);
            }
            this.drawString(this.fontRenderer, this.getMessage(), this.x + this.boxWidth + labelPad, this.y + 2 + yoffset, color);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.visible && mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + this.width) && mouseY < (double)(this.y + this.height)) {
            this.toggle();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyTyped(char c, int i) {
        if (this.isEnabled() && i == 32) {
            this.toggle();
            return true;
        }
        return false;
    }
}

