/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class IntSliderButton
extends Button
implements IConfigFieldHolder<IntegerField> {
    public String prefix = "";
    public boolean dragging = false;
    public int minValue = 0;
    public int maxValue = 0;
    public String suffix = "";
    public boolean drawString = true;
    IntegerField field;

    public IntSliderButton(IntegerField field, String prefix, String suf) {
        this(field, prefix, suf, field.getMinValue(), field.getMaxValue(), true);
    }

    public IntSliderButton(IntegerField field, String prefix, String suf, int minVal, int maxVal, boolean drawStr) {
        super(prefix);
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.prefix = prefix;
        this.suffix = suf;
        this.field = field;
        this.setValue(field.get());
        this.disabledLabelColor = 0x404040;
    }

    public int getHoverState(boolean par1) {
        return 0;
    }

    protected int getYImage(boolean p_getYImage_1_) {
        return 0;
    }

    protected void renderBg(Minecraft mc, int mouseX, int mouseY) {
        mc.func_110434_K().func_110577_a(WIDGETS_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double sliderValue = this.getSliderValue();
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS_LOCATION, (int)(this.x + 1 + (int)(sliderValue * (double)(this.width - 10))), (int)(this.y + 1), (int)0, (int)66, (int)8, (int)(this.height - 2), (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.getBlitOffset());
    }

    protected void onDrag(double mouseX, double mouseY, double mouseDX, double mouseDY) {
        if (this.visible && this.isEnabled()) {
            int k = this.getHoverState(this.isEnabled());
            if (this.isEnabled() && this.dragging) {
                this.setSliderValue((mouseX - (double)(this.x + 4)) / (double)(this.width - 8));
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                double sliderValue = this.getSliderValue();
                GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS_LOCATION, (int)(this.x + 1 + (int)(sliderValue * (double)(this.width - 10))), (int)(this.y + 1), (int)0, (int)66, (int)8, (int)(this.height - 2), (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.getBlitOffset());
            }
        }
    }

    private void renderSlider(double value) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(WIDGETS_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.isHovered() ? 2 : 1) * 20;
        this.blit(this.x + (int)(value * (double)(this.width - 8)), this.y, 0, 46 + i, 4, 20);
        this.blit(this.x + (int)(value * (double)(this.width - 8)) + 4, this.y, 196, 46 + i, 4, 20);
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.x + 4)) / (double)(this.width - 8));
    }

    public void onClick(double mouseX, double mouseY) {
        this.dragging = true;
        this.setValueFromMouse(mouseX);
    }

    public double getSliderValue() {
        return ((double)this.field.get().intValue() - (double)this.minValue * 1.0) / (double)(this.maxValue - this.minValue);
    }

    public void setSliderValue(double sliderValue) {
        if (sliderValue < 0.0) {
            sliderValue = 0.0;
        }
        if (sliderValue > 1.0) {
            sliderValue = 1.0;
        }
        int intVal = (int)Math.round(sliderValue * (double)(this.maxValue - this.minValue) + (double)this.minValue);
        this.setValue(intVal);
    }

    @Override
    public void updateLabel() {
        if (this.drawString) {
            this.setMessage(this.prefix + this.field.get() + this.suffix);
        }
    }

    public void onRelease(double par1, double par2) {
        if (this.dragging) {
            this.dragging = false;
            this.field.save();
            this.checkClickListeners();
        }
    }

    @Override
    public int getFitWidth(FontRenderer fr) {
        int max = fr.func_78256_a(this.prefix + this.minValue + this.suffix);
        max = Math.max(max, fr.func_78256_a(this.prefix + this.maxValue + this.suffix));
        return max + this.WIDTH_PAD;
    }

    public boolean keyTyped(char c, int i) {
        if (this.isEnabled()) {
            if (i == 263 || i == 264 || i == 45) {
                this.setValue(Math.max(this.minValue, this.getValue() - 1));
                return true;
            }
            if (i == 262 || i == 265 || i == 61) {
                this.setValue(Math.min(this.maxValue, this.getValue() + 1));
                return true;
            }
        }
        return false;
    }

    public int getValue() {
        return this.field.get();
    }

    public void setValue(int value) {
        value = Math.min(value, this.maxValue);
        value = Math.max(value, this.minValue);
        if (this.field.get() != value) {
            this.field.set(value);
            if (!this.dragging) {
                this.field.save();
            }
        }
        this.updateLabel();
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get());
    }

    @Override
    public IntegerField getConfigField() {
        return this.field;
    }
}

