/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.SlotGui;
import net.minecraft.client.renderer.Tessellator;

public class ScrollListPane<T extends Slot>
extends SlotGui {
    private final JmUI parent;
    public SlotMetadata lastTooltipMetadata;
    public String[] lastTooltip;
    public long lastTooltipTime;
    public long hoverDelay = 400L;
    private int hpad = 12;
    private List<T> rootSlots;
    private SlotMetadata lastPressed;
    private int lastClickedIndex;
    private int scrollbarX;
    private int listWidth;
    private boolean alignTop;
    List<Slot> currentSlots = new ArrayList<Slot>(0);

    public ScrollListPane(JmUI parent, Minecraft mc, int width, int height, int top, int bottom, int slotHeight) {
        super(mc, width, height, top, bottom, slotHeight);
        this.parent = parent;
        this.updateSize(width, height, top, bottom);
    }

    public void updateSize(int width, int height, int top, int bottom) {
        super.updateSize(width, height, top, bottom);
        this.scrollbarX = this.width - this.hpad;
        this.listWidth = this.width - this.hpad * 4;
    }

    protected int getItemCount() {
        return this.children().size();
    }

    public void setSlots(List<T> slots) {
        this.rootSlots = slots;
        this.updateSlots();
    }

    public List<T> getRootSlots() {
        return this.rootSlots;
    }

    public void updateSlots() {
        int sizeBefore = this.getItemCount();
        this.children().clear();
        int columnWidth = 0;
        for (Slot slot : this.rootSlots) {
            columnWidth = Math.max(columnWidth, slot.getColumnWidth());
        }
        for (Slot slot : this.rootSlots) {
            this.currentSlots.add(slot);
            List<? extends Slot> childSlots = slot.getChildSlots(this.listWidth, columnWidth);
            if (childSlots == null || childSlots.isEmpty()) continue;
            this.currentSlots.addAll(childSlots);
        }
        int sizeAfter = this.getItemCount();
        if (sizeBefore < sizeAfter) {
            this.scroll(-(sizeAfter * this.itemHeight));
            this.scroll(this.lastClickedIndex * this.itemHeight);
        }
    }

    public void scrollTo(Slot slot) {
        this.scroll(-(this.children().size() * this.height));
        this.scroll(this.children().indexOf((Object)slot) * this.height);
    }

    public boolean isSelectedItem(int p_148131_1_) {
        return false;
    }

    public void renderItem(int slotIndex, int x, int y, int slotHeight, int mouseX, int mouseY, float partialTicks) {
        boolean selected = this.isSelectedItem(slotIndex);
        Slot slot = this.getSlot(slotIndex);
        slot.render(slotIndex, 25, y, this.getRowWidth(), slotHeight, mouseX, mouseY, selected, 0.0f);
        SlotMetadata tooltipMetadata = slot.getCurrentTooltip();
        if (tooltipMetadata != null && !Arrays.equals(tooltipMetadata.getTooltip(), this.lastTooltip)) {
            this.lastTooltipMetadata = tooltipMetadata;
            this.lastTooltip = tooltipMetadata.getTooltip();
            this.lastTooltipTime = System.currentTimeMillis();
        }
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int slotIndex;
        if (super.isMouseOver(mouseY, mouseY) && (slotIndex = this.getItemAtPosition(mouseX, mouseY)) >= 0) {
            this.lastClickedIndex = -1;
            if (this.getSlot(slotIndex).mouseClicked(mouseX, mouseY, button)) {
                this.lastClickedIndex = slotIndex;
                this.lastPressed = this.getSlot(slotIndex).getLastPressed();
                this.updateSlots();
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        boolean result = super.mouseReleased(mouseX, mouseY, mouseButton);
        this.lastPressed = null;
        return result;
    }

    public Slot getSlot(int index) {
        return (Slot)this.children().get(index);
    }

    public SlotMetadata getLastPressed() {
        return this.lastPressed;
    }

    public void resetLastPressed() {
        this.lastPressed = null;
    }

    public Slot getLastPressedParentSlot() {
        if (this.lastPressed != null) {
            for (Slot slot : this.rootSlots) {
                if (!slot.contains(this.lastPressed)) continue;
                return slot;
            }
        }
        return null;
    }

    public boolean charTyped(char typedChar, int keyCode) {
        for (int slotIndex = 0; slotIndex < this.getItemCount(); ++slotIndex) {
            if (slotIndex != this.lastClickedIndex) continue;
            return this.getSlot(this.lastClickedIndex).charTyped(typedChar, keyCode);
        }
        return false;
    }

    public boolean keyPressed(int key, int value, int modifier) {
        for (int slotIndex = 0; slotIndex < this.getItemCount(); ++slotIndex) {
            if (slotIndex != this.lastClickedIndex) continue;
            return this.getSlot(this.lastClickedIndex).keyPressed(key, value, modifier);
        }
        return false;
    }

    protected int getScrollbarPosition() {
        return this.scrollbarX;
    }

    protected void renderHoleBackground(int top, int bottom, int topAlpha, int bottomAlpha) {
        super.renderHoleBackground(top, bottom, topAlpha, bottomAlpha);
    }

    protected void drawContainerBackground(Tessellator tessellator) {
    }

    protected void renderBackground() {
        this.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
    }

    public List<? extends IGuiEventListener> children() {
        return this.currentSlots;
    }

    protected int getMaxPosition() {
        int contentHeight = super.getMaxPosition();
        if (this.alignTop) {
            contentHeight = Math.max(this.getBottom() - this.getTop() - 4, contentHeight);
        }
        return contentHeight;
    }

    public int getTop() {
        return this.y0;
    }

    public int getBottom() {
        return this.y1;
    }

    public int getHeight() {
        return this.height;
    }

    public void setAlignTop(boolean alignTop) {
        this.alignTop = alignTop;
    }
}

