/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import journeymap.client.Constants;
import journeymap.client.api.display.Context;
import journeymap.client.api.display.Overlay;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.UIState;
import journeymap.client.data.DataCache;
import journeymap.client.data.WaypointsData;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.io.MapSaver;
import journeymap.client.io.ThemeLoader;
import journeymap.client.log.ChatLog;
import journeymap.client.log.StatTimer;
import journeymap.client.model.BlockMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapState;
import journeymap.client.model.MapType;
import journeymap.client.model.Waypoint;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.properties.MiniMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.map.RegionRenderer;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.task.main.EnsureCurrentColorsTask;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.task.multi.SaveMapTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.IntSliderButton;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.TextBoxButton;
import journeymap.client.ui.dialog.AutoMapConfirmation;
import journeymap.client.ui.dialog.DeleteMapConfirmation;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.fullscreen.MapChat;
import journeymap.client.ui.fullscreen.layer.LayerDelegate;
import journeymap.client.ui.minimap.EntityDisplay;
import journeymap.client.ui.minimap.Shape;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeButton;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.client.ui.theme.ThemeToolbar;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class Fullscreen
extends JmUI {
    private long lastGridUpdate = 0L;
    private static final MapState state = new MapState();
    private static final GridRenderer gridRenderer = new GridRenderer(Context.UI.Fullscreen);
    private final WaypointDrawStepFactory waypointRenderer = new WaypointDrawStepFactory();
    private final RadarDrawStepFactory radarRenderer = new RadarDrawStepFactory();
    private final LayerDelegate layerDelegate;
    private FullMapProperties fullMapProperties = Journeymap.getClient().getFullMapProperties();
    private CoreProperties coreProperties = Journeymap.getClient().getCoreProperties();
    private boolean firstLayoutPass = true;
    private Boolean isScrolling = false;
    private int msx;
    private int msy;
    private int mx;
    private int my;
    private Logger logger = Journeymap.getLogger();
    private MapChat chat;
    private ThemeButton buttonFollow;
    private ThemeButton buttonZoomIn;
    private ThemeButton buttonZoomOut;
    private ThemeButton buttonSearch;
    private TextBoxButton searchTextX;
    private TextBoxButton searchTextZ;
    private ThemeButton buttonExecuteSearch;
    private ThemeToolbar searchToolBar;
    private ThemeButton buttonDay;
    private ThemeButton buttonNight;
    private ThemeButton buttonTopo;
    private ThemeButton buttonLayers;
    private ThemeButton buttonCaves;
    private ThemeButton buttonAlert;
    private ThemeButton buttonOptions;
    private ThemeButton buttonClose;
    private ThemeButton buttonTheme;
    private ThemeButton buttonWaypointManager;
    private ThemeButton buttonMobs;
    private ThemeButton buttonAnimals;
    private ThemeButton buttonPets;
    private ThemeButton buttonVillagers;
    private ThemeButton buttonPlayers;
    private ThemeButton buttonGrid;
    private ThemeButton buttonKeys;
    private ThemeButton buttonAutomap;
    private ThemeButton buttonSavemap;
    private ThemeButton buttonDeletemap;
    private ThemeButton buttonDisable;
    private ThemeButton buttonResetPalette;
    private ThemeButton buttonBrowser;
    private ThemeButton buttonAbout;
    ThemeButton overlayRenderButton;
    private ThemeToolbar mapTypeToolbar;
    private ThemeToolbar optionsToolbar;
    private ThemeToolbar menuToolbar;
    private ThemeToolbar zoomToolbar;
    private int bgColor = 0x222222;
    private Theme.LabelSpec statusLabelSpec;
    private StatTimer renderTimer = StatTimer.get("Fullscreen.render");
    private StatTimer drawMapTimer = StatTimer.get("Fullscreen.render.drawMap", 50);
    private StatTimer drawMapTimerWithRefresh = StatTimer.get("Fullscreen.drawMap+refreshState", 5);
    private LocationFormat locationFormat = new LocationFormat();
    private List<Overlay> tempOverlays = new ArrayList<Overlay>();
    private IntSliderButton sliderCaveLayer;
    private List<String> autoMapOnTooltip;
    private List<String> autoMapOffTooltip;
    private Rectangle2D.Double mapTypeToolbarBounds;
    private Rectangle2D.Double optionsToolbarBounds;
    private Rectangle2D.Double menuToolbarBounds;
    private Minecraft minecraft = Minecraft.func_71410_x();

    public Fullscreen() {
        super(null);
        gridRenderer.setGridSize(Fullscreen.getCalculatedGridSize());
        gridRenderer.clear();
        this.layerDelegate = new LayerDelegate(this);
        if (Journeymap.getClient().getFullMapProperties().showCaves.get().booleanValue() && DataCache.getPlayer().underground.booleanValue() && Fullscreen.state.follow.get() && FeatureManager.isAllowed(Feature.MapCaves)) {
            state.setMapType(MapType.underground(DataCache.getPlayer()));
        }
    }

    public static synchronized MapState state() {
        return state;
    }

    public static synchronized UIState uiState() {
        return gridRenderer.getUIState();
    }

    public void reset() {
        this.isScrolling = false;
        state.requireRefresh();
        gridRenderer.clear();
        this.buttons.clear();
    }

    @Override
    public void init() {
        this.fullMapProperties = Journeymap.getClient().getFullMapProperties();
        state.requireRefresh();
        state.refresh(this.minecraft, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, this.fullMapProperties);
        MapType mapType = state.getMapType();
        this.minecraft.field_195559_v.func_197967_a(true);
        if (mapType.dimension != this.minecraft.field_71439_g.field_71093_bK.func_186068_a()) {
            gridRenderer.clear();
        }
        this.initButtons();
        String thisVersion = Journeymap.JM_VERSION.toString();
        String splashViewed = Journeymap.getClient().getCoreProperties().splashViewed.get();
        if (splashViewed == null || !thisVersion.equals(splashViewed)) {
            UIManager.INSTANCE.openSplash(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(int width, int height, float f) {
        try {
            this.renderBackground(0);
            this.drawMap();
            this.drawLogo();
            this.renderTimer.start();
            this.layoutButtons();
            List<String> tooltip = null;
            if (this.firstLayoutPass) {
                this.layoutButtons();
                this.updateMapType(state.getMapType());
                this.firstLayoutPass = false;
            } else {
                for (int k = 0; k < this.buttons.size(); ++k) {
                    Button button;
                    net.minecraft.client.gui.widget.button.Button guibutton = (net.minecraft.client.gui.widget.button.Button)this.buttons.get(k);
                    guibutton.render(width, height, f);
                    if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(this.mx, this.my)) continue;
                    tooltip = button.getTooltip();
                }
            }
            if (this.chat != null) {
                this.chat.render(width, height, f);
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderTooltip(tooltip, this.mx, this.my, this.getFontRenderer());
                RenderHelper.func_74518_a();
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.ERROR, "Unexpected exception in jm.fullscreen.render(): " + LogFormatter.toString(e));
            UIManager.INSTANCE.closeAll();
        }
        finally {
            this.renderTimer.stop();
        }
    }

    private static int getCalculatedGridSize() {
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        int screenWidth = mainWindow != null ? mainWindow.func_198109_k() : 1920;
        int gridSize = 0;
        while (gridSize * 512 < screenWidth) {
            ++gridSize;
        }
        if (++gridSize % 2 == 0) {
            ++gridSize;
        }
        return gridSize;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        gridRenderer.setGridSize(Fullscreen.getCalculatedGridSize());
        gridRenderer.clear();
    }

    @Override
    public void init(Minecraft minecraft, int width, int height) {
        super.init(minecraft, width, height);
        state.requireRefresh();
        if (this.chat == null) {
            this.chat = new MapChat("", true);
        }
        if (this.chat != null) {
            this.chat.init(minecraft, width, height);
        }
        this.init();
        this.refreshState();
    }

    void initButtons() {
        if (this.buttons.isEmpty()) {
            this.firstLayoutPass = true;
            Theme theme = ThemeLoader.getCurrentTheme();
            MapType mapType = state.getMapType();
            this.bgColor = theme.fullscreen.background.getColor();
            this.statusLabelSpec = theme.fullscreen.statusLabel;
            this.buttonDay = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.fullscreen.map_day", "day", button -> {
                if (this.buttonDay.isEnabled()) {
                    this.updateMapType(MapType.day(state.getDimension()));
                }
            }));
            this.buttonDay.setToggled(mapType.isDay(), false);
            this.buttonDay.setStaysOn(true);
            this.buttonNight = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.fullscreen.map_night", "night", button -> {
                if (this.buttonNight.isEnabled()) {
                    this.updateMapType(MapType.night(state.getDimension()));
                }
            }));
            this.buttonNight.setToggled(mapType.isNight(), false);
            this.buttonNight.setStaysOn(true);
            this.buttonTopo = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.fullscreen.map_topo", "topo", button -> {
                if (this.buttonTopo.isEnabled()) {
                    this.updateMapType(MapType.topo(state.getDimension()));
                }
            }));
            this.buttonTopo.setDrawButton(this.coreProperties.mapTopography.get());
            this.buttonTopo.setToggled(mapType.isTopo(), false);
            this.buttonTopo.setStaysOn(true);
            this.buttonLayers = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.fullscreen.map_cave_layers", "layers", button -> {
                EntityDTO player = DataCache.getPlayer();
                this.buttonLayers.toggle();
                this.sliderCaveLayer.setDrawButton(this.buttonLayers.getToggled());
                if (this.buttonLayers.getToggled().booleanValue() && player.underground.booleanValue()) {
                    this.updateMapType(MapType.underground(player));
                }
            }));
            this.buttonLayers.setEnabled(FeatureManager.isAllowed(Feature.MapCaves));
            FontRenderer fontRenderer = this.getFontRenderer();
            this.sliderCaveLayer = (IntSliderButton)this.addButton((Widget)new IntSliderButton(state.getLastSlice(), Constants.getString("jm.fullscreen.map_cave_layers.button") + " ", ""));
            this.sliderCaveLayer.setWidth(this.sliderCaveLayer.getFitWidth(fontRenderer) + fontRenderer.func_78256_a("0"));
            this.sliderCaveLayer.setDefaultStyle(false);
            this.sliderCaveLayer.setDrawBackground(true);
            Theme.Control.ButtonSpec buttonSpec = this.buttonLayers.getButtonSpec();
            this.sliderCaveLayer.setBackgroundColors(buttonSpec.buttonDisabled.getColor(), buttonSpec.buttonOff.getColor(), buttonSpec.buttonOff.getColor());
            this.sliderCaveLayer.setLabelColors(buttonSpec.iconHoverOff.getColor(), buttonSpec.iconHoverOn.getColor(), buttonSpec.iconDisabled.getColor());
            this.sliderCaveLayer.setDrawButton(false);
            this.buttons.add(this.sliderCaveLayer);
            this.buttonSearch = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.fullscreen.search", "search", button -> {
                this.buttonSearch.toggle();
                this.toggleSearchBar(this.buttonSearch.getToggled());
            }));
            this.searchTextX = (TextBoxButton)this.addButton((Widget)new TextBoxButton("x:", fontRenderer, 40, 20, true, true));
            this.searchTextZ = (TextBoxButton)this.addButton((Widget)new TextBoxButton("z:", fontRenderer, 40, 20, true, true));
            this.buttonExecuteSearch = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.fullscreen.search_execute", "follow", button -> this.executeSearch()));
            this.searchTextX.setVisible(false);
            this.searchTextZ.setVisible(false);
            this.buttonExecuteSearch.setVisible(false);
            this.buttonFollow = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.fullscreen.follow", "follow", button -> this.toggleFollow()));
            this.buttonZoomIn = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.fullscreen.zoom_in", "zoomin", button -> this.zoomIn()));
            this.buttonZoomIn.setEnabled(this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom);
            this.buttonZoomIn.setDisplayClickToggle(false);
            this.buttonZoomOut = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.fullscreen.zoom_out", "zoomout", button -> this.zoomOut()));
            this.buttonZoomOut.setEnabled(this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom);
            this.buttonZoomOut.setDisplayClickToggle(false);
            this.buttonWaypointManager = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.waypoint.waypoints_button", "waypoints", button -> UIManager.INSTANCE.openWaypointManager(null, this)));
            this.buttonWaypointManager.setDrawButton(WaypointsData.isManagerEnabled());
            this.buttonTheme = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.common.ui_theme", "theme", button -> {
                ThemeLoader.loadNextTheme();
                UIManager.INSTANCE.getMiniMap().reset();
                this.buttons.clear();
            }));
            String[] tooltips = new String[]{TextFormatting.ITALIC + Constants.getString("jm.common.ui_theme_name", theme.name), TextFormatting.ITALIC + Constants.getString("jm.common.ui_theme_author", theme.author)};
            this.buttonTheme.setAdditionalTooltips(Arrays.asList(tooltips));
            this.buttonOptions = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.common.options_button", "options", button -> {
                try {
                    UIManager.INSTANCE.openOptionsManager();
                    this.buttons.clear();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }));
            String versionAvailable = Constants.getString("jm.common.new_version_available", VersionCheck.getVersionAvailable());
            this.buttonAlert = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, versionAvailable, versionAvailable, false, "alert", button -> {
                FullscreenActions.launchDownloadWebsite();
                this.buttonAlert.setDrawButton(false);
            }));
            this.buttonAlert.setDrawButton(VersionCheck.getVersionIsChecked() != false && VersionCheck.getVersionIsCurrent() == false);
            this.buttonAlert.setToggled(true);
            this.buttonClose = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.common.close", "close", button -> UIManager.INSTANCE.closeAll()));
            this.buttonCaves = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.common.show_caves", "caves", this.fullMapProperties.showCaves, button -> {
                EntityDTO player = DataCache.getPlayer();
                this.buttonCaves.toggle();
                if (this.buttonCaves.getToggled().booleanValue() && player.underground.booleanValue()) {
                    this.updateMapType(MapType.underground(player));
                }
            }));
            this.buttonCaves.setTooltip(Constants.getString("jm.common.show_caves.tooltip"));
            this.buttonCaves.setDrawButton(state.isCaveMappingAllowed());
            this.buttonMobs = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.common.show_mobs", "monsters", this.fullMapProperties.showMobs, button -> this.buttonMobs.toggle()));
            this.buttonMobs.setTooltip(Constants.getString("jm.common.show_mobs.tooltip"));
            this.buttonMobs.setDrawButton(FeatureManager.isAllowed(Feature.RadarMobs));
            this.buttonAnimals = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.common.show_animals", "animals", this.fullMapProperties.showAnimals, button -> this.buttonAnimals.toggle()));
            this.buttonAnimals.setTooltip(Constants.getString("jm.common.show_animals.tooltip"));
            this.buttonAnimals.setDrawButton(FeatureManager.isAllowed(Feature.RadarAnimals));
            this.buttonPets = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.common.show_pets", "pets", this.fullMapProperties.showPets, button -> this.buttonPets.toggle()));
            this.buttonPets.setTooltip(Constants.getString("jm.common.show_pets.tooltip"));
            this.buttonPets.setDrawButton(FeatureManager.isAllowed(Feature.RadarAnimals));
            this.buttonVillagers = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.common.show_villagers", "villagers", this.fullMapProperties.showVillagers, button -> this.buttonVillagers.toggle()));
            this.buttonVillagers.setTooltip(Constants.getString("jm.common.show_villagers.tooltip"));
            this.buttonVillagers.setDrawButton(FeatureManager.isAllowed(Feature.RadarVillagers));
            this.buttonPlayers = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.common.show_players", "players", this.fullMapProperties.showPlayers, button -> this.buttonPlayers.toggle()));
            this.buttonPlayers.setTooltip(Constants.getString("jm.common.show_players.tooltip"));
            this.buttonPlayers.setDrawButton(!this.minecraft.func_71356_B() && FeatureManager.isAllowed(Feature.RadarPlayers));
            this.buttonGrid = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.common.show_grid", "grid", this.fullMapProperties.showGrid, button -> {
                boolean shiftDown;
                this.buttonGrid.toggle();
                boolean bl = shiftDown = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
                if (shiftDown) {
                    UIManager.INSTANCE.openGridEditor(this);
                    this.buttonGrid.setValue(true);
                }
            }));
            this.buttonGrid.setTooltip(Constants.getString("jm.common.show_grid_shift.tooltip"));
            this.buttonGrid.setTooltip(Constants.getString("jm.common.show_grid_shift.tooltip"));
            this.buttonKeys = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.common.show_keys", "keys", this.fullMapProperties.showKeys, button -> this.buttonKeys.toggle()));
            this.buttonKeys.setTooltip(Constants.getString("jm.common.show_keys.tooltip"));
            this.buttonAbout = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.common.splash_about", "about", button -> UIManager.INSTANCE.openSplash(this)));
            this.overlayRenderButton = new ThemeButton(theme, "jm.debug.region_info_toggle", "server", button -> RegionRenderer.render(!RegionRenderer.TOGGLED));
            this.addButton((Widget)this.overlayRenderButton);
            this.buttonSavemap = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.common.save_map", "savemap", button -> {
                this.buttonSavemap.setEnabled(false);
                try {
                    MapSaver mapSaver = new MapSaver(state.getWorldDir(), state.getMapType());
                    if (mapSaver.isValid()) {
                        Journeymap.getClient().toggleTask(SaveMapTask.Manager.class, true, mapSaver);
                        ChatLog.announceI18N("jm.common.save_filename", mapSaver.getSaveFileName());
                    }
                }
                finally {
                    this.buttonSavemap.setToggled(false);
                    this.buttonSavemap.setEnabled(true);
                }
            }));
            this.buttonBrowser = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.common.use_browser", "browser", button -> FullscreenActions.launchLocalhost()));
            boolean webMapEnabled = Journeymap.getClient().getWebMapProperties().enabled.get();
            this.buttonBrowser.setEnabled(webMapEnabled);
            this.buttonBrowser.setDrawButton(webMapEnabled);
            boolean automapRunning = Journeymap.getClient().isTaskManagerEnabled(MapRegionTask.Manager.class);
            String autoMapOn = Constants.getString("jm.common.automap_stop_title");
            String autoMapOff = Constants.getString("jm.common.automap_title");
            this.autoMapOnTooltip = fontRenderer.func_78271_c(Constants.getString("jm.common.automap_stop_text"), 200);
            this.autoMapOffTooltip = fontRenderer.func_78271_c(Constants.getString("jm.common.automap_text"), 200);
            this.buttonAutomap = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, autoMapOn, autoMapOff, "automap", button -> {
                if (!this.buttonAutomap.getToggled().booleanValue()) {
                    UIManager.INSTANCE.open(AutoMapConfirmation.class, this);
                } else {
                    Journeymap.getClient().toggleTask(MapRegionTask.Manager.class, false, null);
                    this.buttonAutomap.setToggled(false, false);
                    this.buttons.clear();
                }
            }));
            this.buttonAutomap.setEnabled(Minecraft.func_71410_x().func_71356_B() && Journeymap.getClient().getCoreProperties().mappingEnabled.get() != false);
            this.buttonAutomap.setToggled(automapRunning, false);
            this.buttonDeletemap = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.common.deletemap_title", "delete", button -> UIManager.INSTANCE.open(DeleteMapConfirmation.class, this)));
            this.buttonDeletemap.setAdditionalTooltips(fontRenderer.func_78271_c(Constants.getString("jm.common.deletemap_text"), 200));
            this.buttonDisable = (ThemeButton)this.addButton((Widget)new ThemeToggle(theme, "jm.common.enable_mapping_false", "disable", button -> {
                Journeymap.getClient().getCoreProperties().mappingEnabled.set(this.buttonDisable.getToggled() == false);
                if (Journeymap.getClient().getCoreProperties().mappingEnabled.get().booleanValue()) {
                    DataCache.INSTANCE.invalidateChunkMDCache();
                    ChatLog.announceI18N("jm.common.enable_mapping_true_text", new Object[0]);
                } else {
                    Journeymap.getClient().stopMapping();
                    BlockMD.reset();
                    ChatLog.announceI18N("jm.common.enable_mapping_false_text", new Object[0]);
                }
            }));
            this.buttonResetPalette = (ThemeButton)this.addButton((Widget)new ThemeButton(theme, "jm.common.colorreset_title", "reset", button -> Journeymap.getClient().queueMainThreadTask(new EnsureCurrentColorsTask(true, true))));
            this.buttonResetPalette.setAdditionalTooltips(fontRenderer.func_78271_c(Constants.getString("jm.common.colorreset_text"), 200));
            this.mapTypeToolbar = new ThemeToolbar(theme, this.buttonLayers, this.buttonTopo, this.buttonNight, this.buttonDay);
            this.mapTypeToolbar.addAllButtons(this);
            this.optionsToolbar = new ThemeToolbar(theme, this.buttonCaves, this.buttonMobs, this.buttonAnimals, this.buttonPets, this.buttonVillagers, this.buttonPlayers, this.buttonGrid, this.buttonKeys);
            this.optionsToolbar.addAllButtons(this);
            this.optionsToolbar.visible = false;
            this.menuToolbar = new ThemeToolbar(theme, this.buttonWaypointManager, this.buttonOptions, this.buttonAbout, this.buttonBrowser, this.buttonTheme, this.buttonResetPalette, this.buttonDeletemap, this.buttonSavemap, this.buttonAutomap, this.buttonDisable, this.overlayRenderButton);
            this.menuToolbar.addAllButtons(this);
            this.menuToolbar.visible = false;
            this.zoomToolbar = new ThemeToolbar(theme, this.buttonSearch, this.buttonFollow, this.buttonZoomIn, this.buttonZoomOut);
            this.zoomToolbar.setLayout(ButtonList.Layout.Vertical, ButtonList.Direction.LeftToRight);
            this.zoomToolbar.addAllButtons(this);
            this.searchToolBar = new ThemeToolbar(theme, this.searchTextX, this.searchTextZ, this.buttonExecuteSearch);
            this.searchToolBar.setLayout(ButtonList.Layout.CenteredHorizontal, ButtonList.Direction.LeftToRight);
            this.searchToolBar.addAllButtons(this);
            this.buttons.add(this.buttonAlert);
            this.buttons.add(this.buttonClose);
        }
    }

    @Override
    protected void layoutButtons() {
        this.mx = (int)(this.minecraft.field_71417_B.func_198024_e() * (double)this.width / (double)this.minecraft.func_228018_at_().func_198105_m());
        this.my = (int)(this.minecraft.field_71417_B.func_198026_f() * (double)this.height / (double)this.minecraft.func_228018_at_().func_198083_n() - 1.0);
        if (this.buttonDay != null && !this.buttonDay.hasValidTextures()) {
            this.buttons.clear();
        }
        if (this.buttons.isEmpty()) {
            this.initButtons();
        }
        this.menuToolbar.setDrawToolbar(!this.isChatOpen());
        MapType mapType = state.getMapType();
        this.buttonDay.setEnabled(state.isSurfaceMappingAllowed());
        this.buttonDay.setToggled(this.buttonDay.isEnabled() && mapType.isDay());
        this.buttonNight.setEnabled(state.isSurfaceMappingAllowed());
        this.buttonNight.setToggled(this.buttonNight.isEnabled() && mapType.isNight());
        this.buttonTopo.setEnabled(state.isTopoMappingAllowed());
        this.buttonTopo.setToggled(this.buttonTopo.isEnabled() && mapType.isTopo());
        this.buttonCaves.setEnabled(state.isCaveMappingAllowed());
        this.buttonCaves.setToggled(this.buttonCaves.isEnabled() && mapType.isUnderground());
        this.buttonFollow.setEnabled(!Fullscreen.state.follow.get());
        boolean automapRunning = Journeymap.getClient().isTaskManagerEnabled(MapRegionTask.Manager.class);
        boolean mappingEnabled = Journeymap.getClient().getCoreProperties().mappingEnabled.get();
        this.buttonDisable.setToggled(!mappingEnabled, false);
        this.buttonAutomap.setToggled(automapRunning, false);
        this.buttonAutomap.setEnabled(mappingEnabled);
        this.buttonAutomap.setAdditionalTooltips(automapRunning ? this.autoMapOnTooltip : this.autoMapOffTooltip);
        boolean webMapEnabled = Journeymap.getClient().getWebMapProperties().enabled.get();
        this.buttonBrowser.setEnabled(webMapEnabled && mappingEnabled);
        this.buttonBrowser.setDrawButton(webMapEnabled);
        boolean mainThreadActive = Journeymap.getClient().isMainThreadTaskActive();
        this.buttonResetPalette.setEnabled(!mainThreadActive && mappingEnabled);
        this.buttonDeletemap.setEnabled(!mainThreadActive);
        this.buttonDisable.setEnabled(!mainThreadActive);
        this.overlayRenderButton.setVisible(System.getProperty("journeymap.map_testing") != null);
        int padding = this.mapTypeToolbar.getToolbarSpec().padding;
        this.zoomToolbar.layoutCenteredVertical(this.zoomToolbar.getHMargin(), this.height / 2, true, padding);
        this.searchToolBar.layoutHorizontal(this.zoomToolbar.getRightX() + 2, this.zoomToolbar.getY() + 1, true, 7, true);
        this.searchTextX.setX(this.searchTextX.getX() + 3);
        this.searchTextZ.setX(this.searchTextZ.getX() + 2);
        this.buttonExecuteSearch.setDisplayClickToggle(false);
        int topY = this.mapTypeToolbar.getVMargin();
        int margin = this.mapTypeToolbar.getHMargin();
        this.buttonClose.leftOf(this.width - this.zoomToolbar.getHMargin()).below(this.mapTypeToolbar.getVMargin());
        this.buttonAlert.leftOf(this.width - this.zoomToolbar.getHMargin()).below(this.buttonClose, padding);
        int toolbarsWidth = this.mapTypeToolbar.getWidth() + this.optionsToolbar.getWidth() + margin + padding;
        int startX = (this.width - toolbarsWidth) / 2;
        Rectangle2D.Double oldBounds = this.mapTypeToolbar.getBounds();
        this.mapTypeToolbar.layoutHorizontal(startX + this.mapTypeToolbar.getWidth(), topY, false, padding);
        if (!this.mapTypeToolbar.getBounds().equals(oldBounds)) {
            this.mapTypeToolbarBounds = null;
        }
        oldBounds = this.optionsToolbar.getBounds();
        this.optionsToolbar.layoutHorizontal(this.mapTypeToolbar.getRightX() + margin, topY, true, padding);
        this.optionsToolbar.visible = true;
        if (!this.optionsToolbar.getBounds().equals(oldBounds)) {
            this.optionsToolbarBounds = null;
        }
        oldBounds = this.menuToolbar.getBounds();
        this.menuToolbar.layoutCenteredHorizontal(this.width / 2, this.height - this.menuToolbar.getHeight() - this.menuToolbar.getVMargin(), true, padding);
        if (!this.menuToolbar.getBounds().equals(oldBounds)) {
            this.menuToolbarBounds = null;
        }
        if (this.sliderCaveLayer.isVisible()) {
            this.sliderCaveLayer.below(this.buttonLayers, 1).centerHorizontalOn(this.buttonLayers.getCenterX());
            int slice = this.sliderCaveLayer.getValue();
            int minY = Math.max(slice << 4, 0);
            int maxY = (slice + 1 << 4) - 1;
            this.sliderCaveLayer.setTooltip(Constants.getString("jm.fullscreen.map_cave_layers.button.tooltip", minY, maxY));
        }
    }

    @Nullable
    public Rectangle2D.Double getOptionsToolbarBounds() {
        if (this.optionsToolbar != null && this.optionsToolbar.isVisible()) {
            Rectangle2D.Double unscaled = this.optionsToolbar.getBounds();
            this.optionsToolbarBounds = new Rectangle2D.Double(unscaled.x * (double)this.scaleFactor, unscaled.y * (double)this.scaleFactor, unscaled.width * (double)this.scaleFactor, unscaled.height * (double)this.scaleFactor);
        }
        return this.optionsToolbarBounds;
    }

    @Nullable
    public Rectangle2D.Double getMenuToolbarBounds() {
        if (this.menuToolbar != null && this.menuToolbar.isVisible()) {
            Rectangle2D.Double unscaled = this.menuToolbar.getBounds();
            this.menuToolbarBounds = new Rectangle2D.Double(unscaled.x * (double)this.scaleFactor, unscaled.y * (double)this.scaleFactor, unscaled.width * (double)this.scaleFactor, unscaled.height * (double)this.scaleFactor);
        }
        return this.menuToolbarBounds;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double wheel) {
        try {
            if (wheel > 0.0) {
                this.zoomIn();
            } else if (wheel < 0.0) {
                this.zoomOut();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
            return false;
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        try {
            if (this.chat != null && !this.chat.isHidden()) {
                this.chat.mouseClicked(mouseX, mouseY, mouseButton);
            }
            Point2D.Double mousePosition = new Point2D.Double(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor);
            this.mx = (int)(this.minecraft.field_71417_B.func_198024_e() * (double)this.width / (double)this.minecraft.func_228018_at_().func_198105_m());
            this.my = (int)(this.minecraft.field_71417_B.func_198026_f() * (double)this.height / (double)this.minecraft.func_228018_at_().func_198083_n() - 1.0);
            if (!this.isMouseOverButton(mouseX, mouseY)) {
                this.layerDelegate.onMouseClicked(this.minecraft, gridRenderer, mousePosition, mouseButton, this.getMapFontScale());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        long sysTime;
        boolean updateGrid;
        if (this.sliderCaveLayer.dragging || !(this.minecraft.field_71462_r instanceof Fullscreen)) {
            this.isScrolling = false;
        }
        boolean bl = updateGrid = (sysTime = Util.func_211177_b()) - this.lastGridUpdate > 200L;
        if (button == 0 && this.isScrolling.booleanValue() && updateGrid) {
            this.lastGridUpdate = sysTime;
            this.updateGrid();
        }
        if (button == 0 && !this.isScrolling.booleanValue() && !this.isMouseOverButton(mouseX, mouseY)) {
            this.isScrolling = true;
            this.msx = this.mx;
            this.msy = this.my;
            this.minecraft.field_71417_B.func_198021_g();
            Point2D.Double mousePosition = new Point2D.Double(mouseX * (double)this.scaleFactor, mouseY * (double)this.scaleFactor);
            this.layerDelegate.onMouseMove(this.minecraft, gridRenderer, mousePosition, this.getMapFontScale(), this.isScrolling);
        }
        return super.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    private void updateGrid() {
        int blockSize = (int)Math.pow(2.0, this.fullMapProperties.zoomLevel.get().intValue());
        int mouseDragX = (this.mx - this.msx) * Math.max(1, this.scaleFactor) / blockSize;
        int mouseDragY = (this.my - this.msy) * Math.max(1, this.scaleFactor) / blockSize;
        this.msx = this.mx;
        this.msy = this.my;
        try {
            gridRenderer.move(-mouseDragX, -mouseDragY);
            gridRenderer.updateTiles(state.getMapType(), state.getZoom(), state.isHighQuality(), this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n(), false, 0.0, 0.0);
            gridRenderer.setZoom(this.fullMapProperties.zoomLevel.get());
        }
        catch (Exception e) {
            this.logger.error("Error moving grid: " + e);
        }
        this.setFollow(false);
        this.refreshState();
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        try {
            super.mouseReleased(mouseX, mouseY, button);
            if (this.sliderCaveLayer.isVisible()) {
                this.isScrolling = false;
                return true;
            }
            if (this.isScrolling.booleanValue()) {
                this.isScrolling = false;
                this.updateGrid();
            }
            return true;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
            return false;
        }
    }

    public void toggleMapType() {
        this.updateMapType(state.toggleMapType());
    }

    private void updateMapType(MapType newType) {
        if (!newType.isAllowed()) {
            newType = state.getMapType();
        }
        state.setMapType(newType);
        this.buttonDay.setToggled(newType.isDay(), false);
        this.buttonNight.setToggled(newType.isNight(), false);
        this.buttonTopo.setToggled(newType.isTopo(), false);
        if (newType.isUnderground()) {
            this.sliderCaveLayer.setValue(newType.vSlice);
        }
        state.requireRefresh();
    }

    public void zoomIn() {
        if (this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom) {
            this.setZoom(this.fullMapProperties.zoomLevel.get() + 1);
        }
    }

    public void zoomOut() {
        if (this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom) {
            this.setZoom(this.fullMapProperties.zoomLevel.get() - 1);
        }
    }

    private void setZoom(int zoom) {
        if (state.setZoom(zoom)) {
            this.buttonZoomOut.setEnabled(this.fullMapProperties.zoomLevel.get() > Fullscreen.state.minZoom);
            this.buttonZoomIn.setEnabled(this.fullMapProperties.zoomLevel.get() < Fullscreen.state.maxZoom);
            this.refreshState();
        }
    }

    void toggleSearchBar(boolean toggled) {
        this.searchToolBar.setEnabled(toggled);
        this.searchToolBar.setVisible(toggled);
        this.searchTextZ.setVisible(toggled);
        this.searchTextX.setVisible(toggled);
        this.buttonExecuteSearch.setVisible(toggled);
    }

    void executeSearch() {
        this.buttonExecuteSearch.setToggled(true, false);
        try {
            int x = Integer.parseInt(this.searchTextX.getText());
            int z = Integer.parseInt(this.searchTextZ.getText());
            this.centerOn(x, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void toggleFollow() {
        boolean isFollow = !Fullscreen.state.follow.get();
        this.setFollow(isFollow);
        if (isFollow && this.minecraft.field_71439_g != null) {
            this.sliderCaveLayer.setValue(this.minecraft.field_71439_g.field_70162_ai);
            if (state.getMapType().isUnderground()) {
                this.sliderCaveLayer.checkClickListeners();
            }
        }
    }

    void setFollow(Boolean follow) {
        Fullscreen.state.follow.set(follow);
        if (follow.booleanValue()) {
            state.resetMapType();
            this.refreshState();
        }
    }

    public void createWaypointAtMouse() {
        Point2D.Double mousePosition = new Point2D.Double(this.minecraft.field_71417_B.func_198024_e(), (double)gridRenderer.getHeight() - this.minecraft.field_71417_B.func_198026_f());
        BlockPos blockPos = this.layerDelegate.getBlockPos(this.minecraft, gridRenderer, mousePosition);
        Waypoint waypoint = Waypoint.at(blockPos, Waypoint.Type.Normal, this.minecraft.field_71439_g.field_71093_bK.func_186068_a());
        UIManager.INSTANCE.openWaypointEditor(waypoint, true, this);
    }

    public void chatPositionAtMouse() {
        Point2D.Double mousePosition = new Point2D.Double(this.minecraft.field_71417_B.func_198024_e(), (double)gridRenderer.getHeight() - this.minecraft.field_71417_B.func_198026_f());
        BlockPos blockPos = this.layerDelegate.getBlockPos(this.minecraft, gridRenderer, mousePosition);
        Waypoint waypoint = Waypoint.at(blockPos, Waypoint.Type.Normal, state.getDimension());
        this.openChat(waypoint.toChatString());
    }

    public boolean isChatOpen() {
        return this.chat != null && !this.chat.isHidden();
    }

    @Override
    public boolean keyPressed(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                UIManager.INSTANCE.closeAll();
                return true;
            }
        }
        return super.keyPressed(key, value, modifier);
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        if (this.searchTextX.isMouseOver()) {
            return this.searchTextX.charTyped(typedChar, keyCode);
        }
        if (this.searchTextZ.isMouseOver()) {
            return this.searchTextZ.charTyped(typedChar, keyCode);
        }
        if (this.isChatOpen()) {
            return this.chat.charTyped(typedChar, keyCode);
        }
        if (this.minecraft.field_71474_y.field_74310_D.getKey().func_197937_c() == keyCode) {
            this.openChat("");
            return true;
        }
        if (this.minecraft.field_71474_y.field_74323_J.getKey().func_197937_c() == keyCode) {
            this.openChat("/");
            return true;
        }
        return true;
    }

    public void tick() {
        super.tick();
        if (this.chat != null) {
            this.chat.tick();
        }
    }

    public void renderBackground(int layer) {
        DrawUtil.drawRectangle(0.0, 0.0, this.width, this.height, this.bgColor, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawMap() {
        boolean refreshReady = this.isRefreshReady();
        StatTimer timer = refreshReady ? this.drawMapTimerWithRefresh : this.drawMapTimer;
        MapType mapType = state.getMapType();
        timer.start();
        try {
            Point2D.Double playerPixel;
            this.sizeDisplay(false);
            double xOffset = 0.0;
            double yOffset = 0.0;
            if (this.isScrolling.booleanValue()) {
                int blockSize = (int)Math.pow(2.0, this.fullMapProperties.zoomLevel.get().intValue());
                double mouseDragX = (this.mx - this.msx) * Math.max(1, this.scaleFactor) / blockSize;
                double mouseDragY = (this.my - this.msy) * Math.max(1, this.scaleFactor) / blockSize;
                xOffset = mouseDragX * (double)blockSize;
                yOffset = mouseDragY * (double)blockSize;
            } else if (refreshReady) {
                this.refreshState();
            } else {
                gridRenderer.setContext(state.getWorldDir(), mapType);
            }
            gridRenderer.clearGlErrors(false);
            gridRenderer.updateRotation(0.0);
            if (Fullscreen.state.follow.get()) {
                gridRenderer.center(state.getWorldDir(), mapType, this.minecraft.field_71439_g.func_226277_ct_(), this.minecraft.field_71439_g.func_226281_cx_(), this.fullMapProperties.zoomLevel.get());
            }
            gridRenderer.updateTiles(mapType, state.getZoom(), state.isHighQuality(), this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n(), false, 0.0, 0.0);
            gridRenderer.draw(1.0f, xOffset, yOffset, this.fullMapProperties.showGrid.get());
            gridRenderer.draw(state.getDrawSteps(), xOffset, yOffset, (double)this.getMapFontScale(), 0.0);
            gridRenderer.draw(state.getDrawWaypointSteps(), xOffset, yOffset, (double)this.getMapFontScale(), 0.0);
            if (this.fullMapProperties.showSelf.get().booleanValue() && (playerPixel = gridRenderer.getPixel(this.minecraft.field_71439_g.func_226277_ct_(), this.minecraft.field_71439_g.func_226281_cx_())) != null) {
                boolean large = ((EntityDisplay)this.fullMapProperties.playerDisplay.get()).isLarge();
                TextureImpl bgTex = large ? TextureCache.getTexture(TextureCache.PlayerArrowBG_Large) : TextureCache.getTexture(TextureCache.PlayerArrowBG);
                TextureImpl fgTex = large ? TextureCache.getTexture(TextureCache.PlayerArrow_Large) : TextureCache.getTexture(TextureCache.PlayerArrow);
                DrawUtil.drawColoredEntity(((Point2D)playerPixel).getX() + xOffset, ((Point2D)playerPixel).getY() + yOffset, bgTex, 0xFFFFFF, 1.0f, 1.0f, this.minecraft.field_71439_g.field_70759_as);
                int playerColor = this.coreProperties.getColor(this.coreProperties.colorSelf);
                DrawUtil.drawColoredEntity(((Point2D)playerPixel).getX() + xOffset, ((Point2D)playerPixel).getY() + yOffset, fgTex, playerColor, 1.0f, 1.0f, this.minecraft.field_71439_g.field_70759_as);
            }
            gridRenderer.draw(this.layerDelegate.getDrawSteps(), xOffset, yOffset, (double)this.getMapFontScale(), 0.0);
            this.sizeDisplay(true);
        }
        finally {
            timer.stop();
            gridRenderer.clearGlErrors(true);
        }
    }

    private int getMapFontScale() {
        return this.fullMapProperties.fontScale.get();
    }

    public void centerOn(Waypoint waypoint) {
        if (waypoint.getDimensions().contains(this.minecraft.field_71439_g.field_71093_bK.func_186068_a())) {
            if (!waypoint.isPersistent()) {
                this.addTempMarker(waypoint);
            }
            this.centerOn(waypoint.getX(), waypoint.getZ());
        }
    }

    public void centerOn(int x, int z) {
        Fullscreen.state.follow.set(false);
        state.requireRefresh();
        gridRenderer.center(state.getWorldDir(), state.getMapType(), x, z, this.fullMapProperties.zoomLevel.get());
        this.refreshState();
        this.tick();
    }

    public void addTempMarker(Waypoint waypoint) {
        try {
            BlockPos pos = waypoint.getBlockPos();
            PolygonOverlay polygonOverlay = new PolygonOverlay("journeymap", waypoint.getName(), this.minecraft.field_71439_g.field_71093_bK.func_186068_a(), new ShapeProperties().setStrokeColor(255).setStrokeOpacity(1.0f).setStrokeWidth(1.5f), new MapPolygon(pos.func_177982_a(-1, 0, 2), pos.func_177982_a(2, 0, 2), pos.func_177982_a(2, 0, -1), pos.func_177982_a(-1, 0, -1)));
            polygonOverlay.setActiveMapTypes(EnumSet.allOf(Context.MapType.class));
            polygonOverlay.setActiveUIs(EnumSet.of(Context.UI.Fullscreen));
            polygonOverlay.setLabel(waypoint.getName());
            this.tempOverlays.add(polygonOverlay);
            ClientAPI.INSTANCE.show(polygonOverlay);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error showing temp location marker: " + LogFormatter.toPartialString(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshState() {
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        if (player == null) {
            this.logger.warn("Could not get player");
            return;
        }
        StatTimer timer = StatTimer.get("Fullscreen.refreshState");
        timer.start();
        try {
            this.menuToolbarBounds = null;
            this.optionsToolbarBounds = null;
            this.fullMapProperties = Journeymap.getClient().getFullMapProperties();
            state.refresh(this.minecraft, (PlayerEntity)player, this.fullMapProperties);
            MapType mapType = state.getMapType();
            gridRenderer.setContext(state.getWorldDir(), mapType);
            if (Fullscreen.state.follow.get()) {
                gridRenderer.center(state.getWorldDir(), mapType, this.minecraft.field_71439_g.func_226277_ct_(), this.minecraft.field_71439_g.func_226281_cx_(), this.fullMapProperties.zoomLevel.get());
            } else {
                gridRenderer.setZoom(this.fullMapProperties.zoomLevel.get());
            }
            gridRenderer.updateTiles(mapType, state.getZoom(), state.isHighQuality(), this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n(), true, 0.0, 0.0);
            state.generateDrawSteps(this.minecraft, gridRenderer, this.waypointRenderer, this.radarRenderer, this.fullMapProperties, false);
            LocationFormat.LocationFormatKeys locationFormatKeys = this.locationFormat.getFormatKeys(this.fullMapProperties.locationFormat.get());
            Fullscreen.state.playerLastPos = locationFormatKeys.format(this.fullMapProperties.locationFormatVerbose.get(), MathHelper.func_76128_c((double)this.minecraft.field_71439_g.func_226277_ct_()), MathHelper.func_76128_c((double)this.minecraft.field_71439_g.func_226281_cx_()), MathHelper.func_76128_c((double)this.minecraft.field_71439_g.func_174813_aQ().field_72338_b), this.minecraft.field_71439_g.field_70162_ai) + " " + state.getPlayerBiome();
            state.updateLastRefresh();
        }
        finally {
            timer.stop();
        }
        Point2D.Double mousePosition = new Point2D.Double(this.minecraft.field_71417_B.func_198024_e(), (double)gridRenderer.getHeight() - this.minecraft.field_71417_B.func_198026_f());
        this.layerDelegate.onMouseMove(this.minecraft, gridRenderer, mousePosition, this.getMapFontScale(), this.isScrolling);
    }

    public void openChat(String defaultText) {
        if (this.chat != null) {
            this.chat.setText(defaultText);
            this.chat.setHidden(false);
        } else {
            this.chat = new MapChat(defaultText, false);
            this.chat.resize(this.minecraft, this.width, this.height);
        }
    }

    @Override
    public void close() {
        for (Overlay temp : this.tempOverlays) {
            ClientAPI.INSTANCE.remove(temp);
        }
        gridRenderer.updateUIState(false);
        if (this.chat != null) {
            this.chat.close();
        }
    }

    public void onClose() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    boolean isRefreshReady() {
        if (this.isScrolling.booleanValue()) {
            return false;
        }
        return state.shouldRefresh(super.getMinecraft(), this.fullMapProperties) || gridRenderer.hasUnloadedTile();
    }

    public double getScreenScaleFactor() {
        return this.scaleFactor;
    }

    public void moveCanvas(int deltaBlockX, int deltaBlockz) {
        this.refreshState();
        gridRenderer.move(deltaBlockX, deltaBlockz);
        gridRenderer.updateTiles(state.getMapType(), state.getZoom(), state.isHighQuality(), this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n(), true, 0.0, 0.0);
        ClientAPI.INSTANCE.flagOverlaysForRerender();
        this.setFollow(false);
    }

    public void showCaveLayers() {
        if (!state.isUnderground()) {
            this.updateMapType(MapType.underground(3, state.getDimension()));
        }
    }

    @Override
    protected void drawLogo() {
        if (this.logo.isDefunct()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(this.minecraft.func_228018_at_().func_198105_m(), this.minecraft.func_228018_at_().func_198083_n());
        Theme.Container.Toolbar toolbar = ThemeLoader.getCurrentTheme().container.toolbar;
        double scale = this.scaleFactor * 2;
        DrawUtil.sizeDisplay(this.width, this.height);
        DrawUtil.drawImage(this.logo, toolbar.horizontal.margin, toolbar.vertical.margin, false, (float)(1.0 / scale), 0.0);
    }

    @Override
    public final boolean isPauseScreen() {
        return false;
    }

    public void setTheme(String name) {
        try {
            MiniMapProperties mmp = Journeymap.getClient().getMiniMapProperties(Journeymap.getClient().getActiveMinimapId());
            mmp.shape.set(Shape.Rectangle);
            mmp.sizePercent.set(20);
            mmp.save();
            Theme theme = ThemeLoader.getThemeByName(name);
            ThemeLoader.setCurrentTheme(theme);
            UIManager.INSTANCE.getMiniMap().reset();
            ChatLog.announceI18N("jm.common.ui_theme_applied", new Object[0]);
            UIManager.INSTANCE.closeAll();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Could not load Theme: " + LogFormatter.toString(e));
        }
    }
}

