/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.feature;

import com.mojang.authlib.GameProfile;
import journeymap.common.Journeymap;
import journeymap.common.feature.Location;
import journeymap.server.JourneymapServer;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.PropertiesManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class JourneyMapTeleport {
    private static final JourneyMapTeleport INSTANCE = new JourneyMapTeleport();

    private JourneyMapTeleport() {
    }

    public static JourneyMapTeleport instance() {
        return INSTANCE;
    }

    public boolean attemptTeleport(Entity entity, Location location) {
        MinecraftServer mcServer = ServerLifecycleHooks.getCurrentServer();
        boolean creative = false;
        boolean cheatMode = false;
        if (entity == null) {
            Journeymap.getLogger().error("Attempted to teleport null entity.");
            return false;
        }
        if (entity instanceof ServerPlayerEntity) {
            creative = ((ServerPlayerEntity)entity).field_71075_bZ.field_75098_d;
            cheatMode = mcServer.func_184103_al().func_152596_g(new GameProfile(entity.func_110124_au(), entity.func_200200_C_().func_150254_d()));
            if (mcServer == null) {
                entity.func_145747_a((ITextComponent)new StringTextComponent("Cannot Find World"));
                return false;
            }
            if (this.isTeleportAvailable(entity, location) || creative || cheatMode || JourneymapServer.isOp((PlayerEntity)((ServerPlayerEntity)entity))) {
                if (!entity.func_70089_S()) {
                    entity.func_145747_a((ITextComponent)new StringTextComponent("Cannot teleport when dead."));
                    return false;
                }
                ServerWorld destinationWorld = mcServer.func_71218_a(location.getDimType());
                if (destinationWorld == null) {
                    entity.func_145747_a((ITextComponent)new StringTextComponent("Could not get world for Dimension " + location.getDim()));
                    return false;
                }
                return this.teleportEntity(mcServer, destinationWorld, entity, location);
            }
            entity.func_145747_a((ITextComponent)new StringTextComponent("Server has disabled JourneyMap teleport usage for your current or destination dimension."));
            return false;
        }
        return false;
    }

    private boolean isTeleportAvailable(Entity entity, Location location) {
        DimensionProperties destinationProperty = PropertiesManager.getInstance().getDimProperties(location.getDim());
        DimensionProperties entityLocationProperty = PropertiesManager.getInstance().getDimProperties(entity.field_71093_bK.func_186068_a());
        return this.canDimTeleport(destinationProperty) && this.canDimTeleport(entityLocationProperty);
    }

    private boolean canDimTeleport(DimensionProperties properties) {
        if (properties.enabled.get().booleanValue()) {
            return properties.teleportEnabled.get();
        }
        return PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get();
    }

    private boolean teleportEntity(MinecraftServer server, ServerWorld destinationWorld, Entity entity, Location location) {
        ServerWorld startWorld = (ServerWorld)entity.field_70170_p;
        boolean changedWorld = startWorld != destinationWorld;
        PlayerList playerList = server.func_184103_al();
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).func_200619_a(destinationWorld, location.getX(), location.getY(), location.getZ(), entity.field_70177_z, entity.field_70125_A);
        }
        return false;
    }

    private void transferPlayerToWorld(Entity entity, ServerWorld toWorldIn) {
    }
}

