/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.base;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import vazkii.quark.automation.module.ChainLinkageModule;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.SyncChainMessage;

public class ChainHandler {
    public static final String LINKED_TO = "Quark:VehicleLink";
    public static final double DRAG = 0.95;
    public static final float CHAIN_SLACK = 2.0f;
    public static final float MAX_DISTANCE = 8.0f;
    private static final float STIFFNESS = 0.4f;
    private static final float MAX_FORCE = 6.0f;

    private static <T extends Entity> void adjustVelocity(T master, Entity follower) {
        if (master == follower || master.field_70170_p.field_72995_K) {
            return;
        }
        double dist = master.func_70032_d(follower);
        Vec3d masterPosition = master.func_174791_d();
        Vec3d followerPosition = follower.func_174791_d();
        Vec3d masterMotion = master.func_213322_ci();
        Vec3d followerMotion = follower.func_213322_ci();
        Vec3d direction = followerPosition.func_178788_d(masterPosition);
        direction = direction.func_178786_a(0.0, direction.field_72448_b, 0.0).func_72432_b();
        double base = masterMotion.func_72433_c() + followerMotion.func_72433_c();
        if (base != 0.0) {
            double masterRatio = 1.0 + masterMotion.func_72433_c() / base;
            double followerRatio = 1.0 + followerMotion.func_72433_c() / base;
            double stretch = dist - 2.0;
            double springX = (double)0.4f * stretch * direction.field_72450_a;
            double springZ = (double)0.4f * stretch * direction.field_72449_c;
            springX = MathHelper.func_151237_a((double)springX, (double)-6.0, (double)6.0);
            springZ = MathHelper.func_151237_a((double)springZ, (double)-6.0, (double)6.0);
            masterMotion = masterMotion.func_72441_c(springX * followerRatio, 0.0, springZ * followerRatio);
            followerMotion = followerMotion.func_178786_a(springX * masterRatio, 0.0, springZ * masterRatio);
            master.func_213317_d(masterMotion);
            follower.func_213317_d(followerMotion);
        }
    }

    public static UUID getLink(Entity vehicle) {
        if (!ChainHandler.canBeLinked(vehicle)) {
            return null;
        }
        if (!vehicle.getPersistentData().func_186855_b(LINKED_TO)) {
            return null;
        }
        return vehicle.getPersistentData().func_186857_a(LINKED_TO);
    }

    public static boolean canBeLinkedTo(Entity entity) {
        return entity instanceof BoatEntity || entity instanceof AbstractMinecartEntity || entity instanceof PlayerEntity;
    }

    public static boolean canBeLinked(Entity entity) {
        return entity instanceof BoatEntity || entity instanceof AbstractMinecartEntity;
    }

    public static <T extends Entity> Entity getLinked(T vehicle) {
        UUID uuid = ChainHandler.getLink(vehicle);
        if (uuid == null || uuid.equals(SyncChainMessage.NULL_UUID)) {
            return null;
        }
        for (Entity entity : vehicle.field_70170_p.func_175647_a(Entity.class, vehicle.func_174813_aQ().func_186662_g(8.0), ChainHandler::canBeLinkedTo)) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static <T extends Entity> void adjustVehicle(T cart) {
        Entity other = ChainHandler.getLinked(cart);
        if (other == null) {
            if (ChainHandler.getLink(cart) != null) {
                ChainHandler.breakChain(cart);
            }
            return;
        }
        if (!(other instanceof PlayerEntity)) {
            ChainHandler.adjustVelocity(other, cart);
        }
        cart.func_213317_d(cart.func_213322_ci().func_216372_d(0.95, 1.0, 0.95));
    }

    private static <T extends Entity> void breakChain(T cart) {
        ChainHandler.setLink(cart, null, true);
        if (!cart.field_70170_p.field_72995_K && cart.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            cart.func_70099_a(new ItemStack((IItemProvider)ChainLinkageModule.chain), 0.0f);
        }
    }

    public static void setLink(Entity entity, UUID uuid, boolean sync) {
        if (ChainHandler.canBeLinked(entity)) {
            if (entity.func_110124_au().equals(uuid)) {
                return;
            }
            if (uuid != null && !uuid.equals(SyncChainMessage.NULL_UUID)) {
                entity.getPersistentData().func_186854_a(LINKED_TO, uuid);
            } else {
                entity.getPersistentData().func_82580_o("Quark:VehicleLinkMost");
                entity.getPersistentData().func_82580_o("Quark:VehicleLinkLeast");
            }
            if (sync && entity.field_70170_p instanceof ServerWorld) {
                ServerWorld world = (ServerWorld)entity.field_70170_p;
                world.func_72863_F().func_217218_b(entity, QuarkNetwork.toVanillaPacket(new SyncChainMessage(entity.func_145782_y(), uuid), NetworkDirection.PLAY_TO_CLIENT));
            }
        }
    }
}

