/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.module;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.IPistonCallback;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;

@LoadModule(category=ModuleCategory.AUTOMATION, hasSubscriptions=true)
public class PistonsMoveTileEntitiesModule
extends Module {
    private static final WeakHashMap<World, Map<BlockPos, CompoundNBT>> movements = new WeakHashMap();
    private static final WeakHashMap<World, List<Pair<BlockPos, CompoundNBT>>> delayedUpdates = new WeakHashMap();
    @Config
    public static List<String> renderBlacklist = Lists.newArrayList((Object[])new String[]{"psi:programmer", "botania:starfield"});
    @Config
    public static List<String> movementBlacklist = Lists.newArrayList((Object[])new String[]{"minecraft:spawner", "integrateddynamics:cable", "randomthings:blockbreaker", "minecraft:ender_chest", "minecraft:enchanting_table", "minecraft:trapped_chest", "quark:spruce_trapped_chest", "quark:birch_trapped_chest", "quark:jungle_trapped_chest", "quark:acacia_trapped_chest", "quark:dark_oak_trapped_chest"});
    @Config
    public static List<String> delayedUpdateList = Lists.newArrayList((Object[])new String[]{"minecraft:dispenser", "minecraft:dropper"});

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!delayedUpdates.containsKey(event.world) || event.phase == TickEvent.Phase.START) {
            return;
        }
        List<Pair<BlockPos, CompoundNBT>> delays = delayedUpdates.get(event.world);
        if (delays.isEmpty()) {
            return;
        }
        for (Pair<BlockPos, CompoundNBT> delay : delays) {
            TileEntity tile = TileEntity.func_203403_c((CompoundNBT)((CompoundNBT)delay.getRight()));
            event.world.func_175690_a((BlockPos)delay.getLeft(), tile);
            if (tile == null) continue;
            tile.func_145836_u();
        }
        delays.clear();
    }

    public static boolean shouldMoveTE(boolean te, BlockState state) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(PistonsMoveTileEntitiesModule.class)) {
            return te;
        }
        return PistonsMoveTileEntitiesModule.shouldMoveTE(state);
    }

    public static boolean shouldMoveTE(BlockState state) {
        if (state.func_206869_a().contains(JukeboxBlock.field_176432_a) && ((Boolean)state.func_177229_b((IProperty)JukeboxBlock.field_176432_a)).booleanValue()) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150332_K) {
            return true;
        }
        ResourceLocation res = state.func_177230_c().getRegistryName();
        return res == null || movementBlacklist.contains(res.toString()) || movementBlacklist.contains(res.func_110624_b());
    }

    public static void detachTileEntities(World world, PistonBlockStructureHelper helper, Direction facing, boolean extending) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(PistonsMoveTileEntitiesModule.class)) {
            return;
        }
        if (!extending) {
            facing = facing.func_176734_d();
        }
        List moveList = helper.func_177254_c();
        for (BlockPos pos : moveList) {
            TileEntity tile;
            BlockState state = world.func_180495_p(pos);
            if (!state.func_177230_c().hasTileEntity(state) || (tile = world.func_175625_s(pos)) == null) continue;
            if (PistonsMoveTileEntitiesModule.hasCallback(tile)) {
                PistonsMoveTileEntitiesModule.getCallback(tile).onPistonMovementStarted();
            }
            world.func_175713_t(pos);
            PistonsMoveTileEntitiesModule.registerMovement(world, pos.func_177972_a(facing), tile);
        }
    }

    public static boolean setPistonBlock(World world, BlockPos pos, BlockState state, int flags) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(PistonsMoveTileEntitiesModule.class)) {
            world.func_180501_a(pos, state, flags);
            return false;
        }
        if (state.func_206869_a().contains(ChestBlock.field_196314_b)) {
            state = (BlockState)state.func_206870_a((IProperty)ChestBlock.field_196314_b, (Comparable)ChestType.SINGLE);
        }
        Block block = state.func_177230_c();
        TileEntity tile = PistonsMoveTileEntitiesModule.getAndClearMovement(world, pos);
        boolean destroyed = false;
        if (tile != null) {
            BlockState currState = world.func_180495_p(pos);
            TileEntity currTile = world.func_175625_s(pos);
            world.func_217377_a(pos, false);
            if (!block.func_196260_a(state, (IWorldReader)world, pos)) {
                world.func_180501_a(pos, state, flags);
                world.func_175690_a(pos, tile);
                Block.func_220059_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)tile);
                world.func_217377_a(pos, false);
                destroyed = true;
            }
            if (!destroyed) {
                world.func_175656_a(pos, currState);
                world.func_175690_a(pos, currTile);
            }
        }
        if (!destroyed) {
            world.func_180501_a(pos, state, flags);
            if (world.func_175625_s(pos) != null) {
                world.func_180501_a(pos, state, 0);
            }
            if (tile != null && !world.field_72995_K) {
                if (delayedUpdateList.contains(block.getRegistryName().toString())) {
                    PistonsMoveTileEntitiesModule.registerDelayedUpdate(world, pos, tile);
                } else {
                    world.func_175690_a(pos, tile);
                    tile.func_145836_u();
                }
            }
            world.func_195593_d(pos, block);
        }
        return false;
    }

    private static void registerMovement(World world, BlockPos pos, TileEntity tile) {
        if (!movements.containsKey(world)) {
            movements.put(world, new HashMap());
        }
        movements.get(world).put(pos, tile.serializeNBT());
    }

    public static TileEntity getMovement(World world, BlockPos pos) {
        return PistonsMoveTileEntitiesModule.getMovement(world, pos, false);
    }

    private static TileEntity getMovement(World world, BlockPos pos, boolean remove) {
        if (!movements.containsKey(world)) {
            return null;
        }
        Map<BlockPos, CompoundNBT> worldMovements = movements.get(world);
        if (!worldMovements.containsKey(pos)) {
            return null;
        }
        CompoundNBT ret = worldMovements.get(pos);
        if (remove) {
            worldMovements.remove(pos);
        }
        return TileEntity.func_203403_c((CompoundNBT)ret);
    }

    private static TileEntity getAndClearMovement(World world, BlockPos pos) {
        TileEntity tile = PistonsMoveTileEntitiesModule.getMovement(world, pos, true);
        if (tile != null) {
            if (PistonsMoveTileEntitiesModule.hasCallback(tile)) {
                PistonsMoveTileEntitiesModule.getCallback(tile).onPistonMovementFinished();
            }
            tile.func_174878_a(pos);
            tile.func_145829_t();
        }
        return tile;
    }

    private static void registerDelayedUpdate(World world, BlockPos pos, TileEntity tile) {
        if (!delayedUpdates.containsKey(world)) {
            delayedUpdates.put(world, new ArrayList());
        }
        delayedUpdates.get(world).add((Pair<BlockPos, CompoundNBT>)Pair.of((Object)pos, (Object)tile.serializeNBT()));
    }

    private static boolean hasCallback(TileEntity tile) {
        return tile.getCapability(QuarkCapabilities.PISTON_CALLBACK).isPresent();
    }

    private static IPistonCallback getCallback(TileEntity tile) {
        return (IPistonCallback)tile.getCapability(QuarkCapabilities.PISTON_CALLBACK).orElse(() -> {});
    }
}

