/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import vazkii.quark.api.event.ModuleLoadedEvent;
import vazkii.quark.api.event.ModuleStateChangedEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.ConfigFlagManager;

public class Module {
    public String displayName = "";
    public String lowercaseName = "";
    public String description = "";
    public List<String> antiOverlap = null;
    public boolean hasSubscriptions = false;
    public List<Dist> subscriptionTarget = Lists.newArrayList((Object[])new Dist[]{Dist.CLIENT, Dist.DEDICATED_SERVER});
    public boolean enabledByDefault = true;
    private boolean firstLoad = true;
    public boolean enabled = false;
    public boolean ignoreAntiOverlap = false;

    public void construct() {
    }

    public void modulesStarted() {
    }

    public void buildConfigSpec(ForgeConfigSpec.Builder builder, List<Runnable> callbacks) {
    }

    public void configChanged() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void configChangedClient() {
    }

    public void earlySetup() {
    }

    public void setup() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistry() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void textureStitch(TextureStitchEvent.Pre event) {
    }

    public void loadComplete() {
    }

    public void pushFlags(ConfigFlagManager manager) {
    }

    public final void setEnabled(boolean enabled) {
        if (this.firstLoad) {
            Quark.LOG.info("Loading Module " + this.displayName);
            MinecraftForge.EVENT_BUS.post((Event)new ModuleLoadedEvent(this.lowercaseName));
        }
        this.firstLoad = false;
        if (!this.ignoreAntiOverlap && this.antiOverlap != null) {
            ModList list = ModList.get();
            for (String s : this.antiOverlap) {
                if (!list.isLoaded(s)) continue;
                return;
            }
        }
        this.setEnabledAndManageSubscriptions(enabled);
    }

    private void setEnabledAndManageSubscriptions(boolean enabled) {
        if (MinecraftForge.EVENT_BUS.post((Event)new ModuleStateChangedEvent(this.lowercaseName, enabled))) {
            enabled = false;
        }
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        if (this.hasSubscriptions && this.subscriptionTarget.contains(FMLEnvironment.dist) && wasEnabled != enabled) {
            if (enabled) {
                MinecraftForge.EVENT_BUS.register((Object)this);
            } else {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
        }
    }
}

