/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import vazkii.quark.base.client.GenericChestTERenderer;
import vazkii.quark.building.module.VariantChestsModule;

public class VariantChestTileEntityRenderer
extends GenericChestTERenderer<ChestTileEntity> {
    private static Map<Block, ChestTextureBatch> chestTextures = new HashMap<Block, ChestTextureBatch>();
    public static Block invBlock = null;

    public VariantChestTileEntityRenderer(TileEntityRendererDispatcher disp) {
        super(disp);
    }

    @Override
    public Material getMaterial(ChestTileEntity t, ChestType type) {
        Block block = invBlock;
        if (block == null) {
            block = t.func_195044_w().func_177230_c();
        }
        ChestTextureBatch batch = chestTextures.get(block);
        switch (type) {
            case LEFT: {
                return batch.left;
            }
            case RIGHT: {
                return batch.right;
            }
        }
        return batch.normal;
    }

    public static void accept(TextureStitchEvent.Pre event, Block chest) {
        ResourceLocation atlas = event.getMap().func_229223_g_();
        if (chest instanceof VariantChestsModule.IChestTextureProvider) {
            VariantChestsModule.IChestTextureProvider prov = (VariantChestsModule.IChestTextureProvider)chest;
            String path = prov.getChestTexturePath();
            if (!prov.isTrap()) {
                VariantChestTileEntityRenderer.add(event, atlas, chest, path, "normal", "left", "right");
            } else {
                VariantChestTileEntityRenderer.add(event, atlas, chest, path, "trap", "trap_left", "trap_right");
            }
        }
    }

    private static void add(TextureStitchEvent.Pre event, ResourceLocation atlas, Block chest, String path, String normal, String left, String right) {
        ResourceLocation resNormal = new ResourceLocation("quark", path + normal);
        ResourceLocation resLeft = new ResourceLocation("quark", path + left);
        ResourceLocation resRight = new ResourceLocation("quark", path + right);
        ChestTextureBatch batch = new ChestTextureBatch(atlas, resNormal, resLeft, resRight);
        chestTextures.put(chest, batch);
        event.addSprite(resNormal);
        event.addSprite(resLeft);
        event.addSprite(resRight);
    }

    private static class ChestTextureBatch {
        public final Material normal;
        public final Material left;
        public final Material right;

        public ChestTextureBatch(ResourceLocation atlas, ResourceLocation normal, ResourceLocation left, ResourceLocation right) {
            this.normal = new Material(atlas, normal);
            this.left = new Material(atlas, left);
            this.right = new Material(atlas, right);
        }
    }
}

