/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.module;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.building.block.VariantChestBlock;
import vazkii.quark.building.block.VariantTrappedChestBlock;
import vazkii.quark.building.client.render.VariantChestTileEntityRenderer;
import vazkii.quark.building.tile.VariantChestTileEntity;
import vazkii.quark.building.tile.VariantTrappedChestTileEntity;

@LoadModule(category=ModuleCategory.BUILDING, hasSubscriptions=true)
public class VariantChestsModule
extends Module {
    private static final String DONK_CHEST = "Quark:DonkChest";
    private static final ImmutableSet<String> WOODS = ImmutableSet.of((Object)"oak", (Object)"spruce", (Object)"birch", (Object)"jungle", (Object)"acacia", (Object)"dark_oak", (Object[])new String[0]);
    private static final ImmutableSet<String> MOD_WOODS = ImmutableSet.of((Object)"bambooblocks:bamboo", (Object)"upgrade_aquatic:driftwood", (Object)"endergetic:poise", (Object)"swampexpansion:willow", (Object)"bloomful:wisteria", (Object)"buzzierbees:hive", (Object[])new String[]{"atmospheric:rosewood"});
    public static TileEntityType<VariantChestTileEntity> chestTEType;
    public static TileEntityType<VariantTrappedChestTileEntity> trappedChestTEType;
    private static List<Supplier<Block>> chestTypes;
    private static List<Supplier<Block>> trappedChestTypes;
    private static List<Block> allChests;
    private static final ThreadLocal<ItemStack> WAIT_TO_REPLACE_CHEST;

    @Override
    public void construct() {
        WOODS.forEach(s -> this.addChest((String)s, Blocks.field_150486_ae));
        MOD_WOODS.forEach(s -> this.addModChest((String)s, Blocks.field_150486_ae));
        this.addChest("nether_brick", Blocks.field_196653_dH);
        this.addChest("purpur", Blocks.field_185767_cT);
        this.addChest("prismarine", Blocks.field_180397_cI);
        this.addChest("mushroom", Blocks.field_150419_aX);
        chestTEType = VariantChestsModule.registerChests(VariantChestTileEntity::new, chestTypes);
        trappedChestTEType = VariantChestsModule.registerChests(VariantTrappedChestTileEntity::new, trappedChestTypes);
        RegistryHelper.register(chestTEType, (String)"variant_chest");
        RegistryHelper.register(trappedChestTEType, (String)"variant_trapped_chest");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        ClientRegistry.bindTileEntityRenderer(chestTEType, d -> new VariantChestTileEntityRenderer((TileEntityRendererDispatcher)d));
        ClientRegistry.bindTileEntityRenderer(trappedChestTEType, d -> new VariantChestTileEntityRenderer((TileEntityRendererDispatcher)d));
    }

    private void addChest(String name, Block from) {
        this.addChest(name, Block.Properties.func_200950_a((Block)from));
    }

    private void addChest(String name, Block.Properties props) {
        chestTypes.add((Supplier<Block>)((Supplier)() -> new VariantChestBlock(name, this, (Supplier<TileEntityType<? extends ChestTileEntity>>)((Supplier)() -> chestTEType), props)));
        trappedChestTypes.add((Supplier<Block>)((Supplier)() -> new VariantTrappedChestBlock(name, this, (Supplier<TileEntityType<? extends ChestTileEntity>>)((Supplier)() -> trappedChestTEType), props)));
    }

    private void addModChest(String nameRaw, Block from) {
        String[] toks = nameRaw.split(":");
        String name = toks[1];
        String mod = toks[0];
        this.addModChest(name, mod, Block.Properties.func_200950_a((Block)from));
    }

    private void addModChest(String name, String mod, Block.Properties props) {
        chestTypes.add((Supplier<Block>)((Supplier)() -> new VariantChestBlock.Compat(name, mod, this, (Supplier<TileEntityType<? extends ChestTileEntity>>)((Supplier)() -> chestTEType), props)));
        trappedChestTypes.add((Supplier<Block>)((Supplier)() -> new VariantTrappedChestBlock.Compat(name, mod, this, (Supplier<TileEntityType<? extends ChestTileEntity>>)((Supplier)() -> trappedChestTEType), props)));
    }

    public static <T extends TileEntity> TileEntityType<T> registerChests(Supplier<? extends T> factory, List<Supplier<Block>> list) {
        List<Block> blockTypes = list.stream().map(Supplier::get).collect(Collectors.toList());
        allChests.addAll(blockTypes);
        return TileEntityType.Builder.func_223042_a(factory, (Block[])blockTypes.toArray(new Block[blockTypes.size()])).func_206865_a(null);
    }

    @Override
    public void textureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().toString().equals("minecraft:textures/atlas/chest.png")) {
            for (Block b : allChests) {
                VariantChestTileEntityRenderer.accept(event, b);
            }
        }
    }

    @SubscribeEvent
    public void onClickEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        AbstractChestedHorseEntity horse;
        Entity target = event.getTarget();
        PlayerEntity player = event.getPlayer();
        ItemStack held = player.func_184586_b(event.getHand());
        if (!held.func_190926_b() && target instanceof AbstractChestedHorseEntity && !(horse = (AbstractChestedHorseEntity)target).func_190695_dh() && held.func_77973_b() != Items.field_221675_bZ && held.func_77973_b().func_206844_a(Tags.Items.CHESTS_WOODEN)) {
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.SUCCESS);
            if (!target.field_70170_p.field_72995_K) {
                ItemStack copy = held.func_77946_l();
                copy.func_190920_e(1);
                held.func_190918_g(1);
                horse.getPersistentData().func_218657_a(DONK_CHEST, (INBT)copy.serializeNBT());
                horse.func_110207_m(true);
                horse.func_110226_cD();
                horse.func_190697_dk();
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        AbstractChestedHorseEntity horse;
        ItemStack chest;
        LivingEntity target = event.getEntityLiving();
        if (target instanceof AbstractChestedHorseEntity && !(chest = ItemStack.func_199557_a((CompoundNBT)(horse = (AbstractChestedHorseEntity)target).getPersistentData().func_74775_l(DONK_CHEST))).func_190926_b() && horse.func_190695_dh()) {
            WAIT_TO_REPLACE_CHEST.set(chest);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity target = event.getEntity();
        if (target instanceof ItemEntity && ((ItemEntity)target).func_92059_d().func_77973_b() == Items.field_221675_bZ) {
            ItemStack local = WAIT_TO_REPLACE_CHEST.get();
            if (local != null && !local.func_190926_b()) {
                ((ItemEntity)target).func_92058_a(local);
            }
            WAIT_TO_REPLACE_CHEST.remove();
        }
    }

    static {
        chestTypes = new LinkedList<Supplier<Block>>();
        trappedChestTypes = new LinkedList<Supplier<Block>>();
        allChests = new LinkedList<Block>();
        WAIT_TO_REPLACE_CHEST = new ThreadLocal();
    }

    public static interface IChestTextureProvider {
        public String getChestTexturePath();

        public boolean isTrap();
    }
}

