/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mobs.entity;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BegGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.mobs.ai.FindPlaceToSleepGoal;
import vazkii.quark.mobs.ai.SleepGoal;
import vazkii.quark.mobs.module.FoxhoundModule;
import vazkii.quark.tweaks.ai.WantLoveGoal;

public class FoxhoundEntity
extends WolfEntity
implements IMob {
    public static final ResourceLocation FOXHOUND_LOOT_TABLE = new ResourceLocation("quark", "entities/foxhound");
    private static final DataParameter<Boolean> TEMPTATION = EntityDataManager.func_187226_a(FoxhoundEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(FoxhoundEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int timeUntilPotatoEmerges = 0;
    protected SleepGoal sleepGoal;

    public FoxhoundEntity(EntityType<? extends FoxhoundEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 1.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_175547_a(DyeColor.ORANGE);
        this.field_70180_af.func_187214_a(TEMPTATION, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
    }

    public boolean func_104002_bU() {
        return super.func_104002_bU();
    }

    public boolean func_213392_I() {
        return this.func_70909_n();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_70909_n();
    }

    public boolean func_70094_T() {
        return MiscUtil.isEntityInsideOpaqueBlock((Entity)this);
    }

    public void func_70071_h_() {
        BlockPos below;
        TileEntity tile;
        LivingEntity owner;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && !this.func_70909_n()) {
            this.func_70106_y();
            return;
        }
        if (!(!WantLoveGoal.needsPets((TameableEntity)this) || (owner = this.func_70902_q()) == null || !(owner.func_70068_e((Entity)this) < 1.0) || owner.func_70090_H() || owner.func_70045_F() || owner instanceof PlayerEntity && ((PlayerEntity)owner).func_184812_l_())) {
            owner.func_70015_d(5);
        }
        Vec3d pos = this.func_213303_ch();
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)(this.func_70608_bn() ? ParticleTypes.field_197601_L : ParticleTypes.field_197631_x), pos.field_72450_a + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), pos.field_72448_b + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213302_cg(), pos.field_72449_c + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
        }
        if (this.func_70909_n() && (tile = this.field_70170_p.func_175625_s(below = this.func_180425_c().func_177977_b())) instanceof FurnaceTileEntity) {
            List foxhounds;
            FurnaceTileEntity furnace = (FurnaceTileEntity)tile;
            int cookTime = furnace.field_214020_l;
            if (cookTime > 0 && cookTime % 3 == 0 && !(foxhounds = this.field_70170_p.func_175647_a(FoxhoundEntity.class, new AxisAlignedBB(this.func_180425_c()), fox -> fox != null && fox.func_70909_n())).isEmpty() && foxhounds.get(0) == this) {
                furnace.field_214020_l = Math.min(furnace.field_214021_m - 1, cookTime + 1);
            }
        }
    }

    public boolean func_70026_G() {
        return false;
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        return FOXHOUND_LOOT_TABLE;
    }

    protected void func_184651_r() {
        this.field_70911_d = new SitGoal((TameableEntity)this);
        this.sleepGoal = new SleepGoal(this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)this.sleepGoal);
        this.field_70714_bg.func_75776_a(3, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FindPlaceToSleepGoal(this, 0.8, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new FindPlaceToSleepGoal(this, 0.8, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(9, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (Goal)new BegGoal((WolfEntity)this, 8.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, target -> target instanceof SheepEntity || target instanceof RabbitEntity));
        this.field_70715_bh.func_75776_a(4, (Goal)new NonTamedTargetGoal((TameableEntity)this, PlayerEntity.class, false, target -> !this.func_70909_n()));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
    }

    public boolean func_70919_bu() {
        return !this.func_70909_n() && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL || super.func_70919_bu();
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn.func_70045_F()) {
            if (entityIn instanceof PlayerEntity) {
                return false;
            }
            return super.func_70652_k(entityIn);
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_76361_j(), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            entityIn.func_70015_d(5);
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        this.setWoke();
        return super.func_70097_a(source, amount);
    }

    public boolean func_184645_a(PlayerEntity player, @Nonnull Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151103_aS && !this.func_70909_n()) {
            return false;
        }
        if (!(this.func_70909_n() || itemstack.func_190926_b() || itemstack.func_77973_b() != Items.field_151044_h || this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && !player.func_184812_l_() && player.func_70660_b(Effects.field_76426_n) == null || this.field_70170_p.field_72995_K)) {
            if (this.field_70146_Z.nextDouble() < FoxhoundModule.tameChance) {
                this.func_193101_c(player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.field_70911_d.func_75270_a(true);
                this.func_70606_j(20.0f);
                this.func_70908_e(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.func_70908_e(false);
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setWoke();
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        return super.func_70878_b(otherAnimal) && otherAnimal instanceof FoxhoundEntity;
    }

    public WolfEntity func_90011_a(AgeableEntity otherParent) {
        FoxhoundEntity entitywolf = new FoxhoundEntity(FoxhoundModule.foxhoundType, this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            entitywolf.func_184754_b(uuid);
            entitywolf.func_70903_f(true);
        }
        return entitywolf;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("OhLawdHeComin", this.timeUntilPotatoEmerges);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.timeUntilPotatoEmerges = compound.func_74762_e("OhLawdHeComin");
    }

    protected SoundEvent func_184639_G() {
        return this.func_70608_bn() ? null : super.func_184639_G();
    }

    public boolean func_70608_bn() {
        return (Boolean)this.field_70180_af.func_187225_a(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleeping);
    }

    public static boolean canSpawnHere(IWorld world, BlockPos pos, Random rand) {
        if (world.func_226658_a_(LightType.SKY, pos) > rand.nextInt(32)) {
            return false;
        }
        int light = world.func_201672_e().func_72911_I() ? world.func_205049_d(pos, 10) : world.func_201696_r(pos);
        return light <= rand.nextInt(8);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150424_aL ? 10.0f : worldIn.func_205052_D(pos) - 0.5f;
    }

    public static boolean spawnPredicate(EntityType<? extends FoxhoundEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && FoxhoundEntity.canSpawnHere(world, pos, rand);
    }

    public SleepGoal getSleepGoal() {
        return this.sleepGoal;
    }

    private void setWoke() {
        SleepGoal sleep = this.getSleepGoal();
        if (sleep != null) {
            this.setSleeping(false);
            sleep.setSleeping(false);
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

