/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import vazkii.quark.base.world.config.ClusterSizeConfig;
import vazkii.quark.base.world.config.DimensionConfig;
import vazkii.quark.base.world.generator.multichunk.ClusterBasedGenerator;

public class MegaCaveGenerator
extends ClusterBasedGenerator {
    public MegaCaveGenerator(DimensionConfig dimConfig, ClusterSizeConfig sizeConfig) {
        super(dimConfig, sizeConfig, 4L);
    }

    @Override
    public ClusterBasedGenerator.IGenerationContext createContext(BlockPos src, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos chunkCorner, IWorld world) {
        return pos -> {
            BlockState state = world.func_180495_p(pos);
            if (state.func_185887_b((IBlockReader)world, pos) > -1.0f) {
                if (pos.func_177956_o() < 6) {
                    world.func_180501_a(pos, Blocks.field_150353_l.func_176223_P(), 0);
                } else {
                    world.func_217377_a(pos, false);
                }
            }
        };
    }

    @Override
    public BlockPos[] getSourcesInChunk(IWorld world, Random random, ChunkGenerator<? extends GenerationSettings> generator, BlockPos chunkLeft) {
        int rarity;
        if (!(generator instanceof FlatChunkGenerator) && (rarity = this.shapeProvider.getRarity()) > 0 && random.nextInt(rarity) == 0) {
            BlockPos pos = chunkLeft.func_177982_a(random.nextInt(16), this.shapeProvider.getRandomYLevel(random), random.nextInt(16));
            if (this.shapeProvider.getBiomeTypes().canSpawn(this.getBiome(world, pos))) {
                return new BlockPos[]{pos};
            }
        }
        return new BlockPos[0];
    }
}

