/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.gen.structure;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.ScatteredStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;
import vazkii.quark.base.world.JigsawRegistryHelper;
import vazkii.quark.world.gen.structure.processor.BigDungeonChestProcessor;
import vazkii.quark.world.gen.structure.processor.BigDungeonSpawnerProcessor;
import vazkii.quark.world.module.BigDungeonModule;

public class BigDungeonStructure
extends ScatteredStructure<NoFeatureConfig> {
    private static final List<Biome.SpawnListEntry> ENEMIES = Lists.newArrayList((Object[])new Biome.SpawnListEntry[]{new Biome.SpawnListEntry(EntityType.field_200725_aD, 8, 1, 3), new Biome.SpawnListEntry(EntityType.field_200741_ag, 8, 1, 3), new Biome.SpawnListEntry(EntityType.field_200797_k, 8, 1, 3), new Biome.SpawnListEntry(EntityType.field_200759_ay, 4, 1, 1), new Biome.SpawnListEntry(EntityType.field_200764_D, 10, 1, 1)});
    private static final String NAMESPACE = "big_dungeon";
    private static final String STARTS_DIR = "starts";
    private static final Set<String> STARTS = ImmutableSet.of((Object)"3x3_pillars", (Object)"3x3_tnt", (Object)"3x3_water", (Object)"plus_barricade", (Object)"plus_ores", (Object)"plus_plain", (Object[])new String[]{"triplex_3sect", "triplex_lava", "triplex_plain"});
    private static final String ROOMS_DIR = "rooms";
    private static final Set<String> ROOMS = ImmutableSet.of((Object)"4room_plain", (Object)"4room_trapped", (Object)"ascend_intersection", (Object)"ascend_ruined", (Object)"ascend_plain", (Object)"climb_parkour", (Object[])new String[]{"climb_redstone", "climb_plain", "double_hall_plain", "double_hall_silverfish", "laddered_bridge", "laddered_tnt", "laddered_plain", "triple_library", "triple_plain", "connector_base", "connector_bush", "connector_fountain", "connector_melon", "connector_room"});
    private static final String CORRIDORS_DIR = "corridors";
    private static final Set<String> CORRIDORS = ImmutableSet.of((Object)"forward_cobweb", (Object)"forward_plain", (Object)"left_cobweb", (Object)"left_plain", (Object)"right_cobweb", (Object)"right_plain", (Object[])new String[]{"t_cobweb", "t_plain"});
    private static final String ENDPOINT = "misc/endpoint";
    private static final ResourceLocation START_POOL = new ResourceLocation("quark", "big_dungeon/starts");

    public BigDungeonStructure() {
        super(fc -> NoFeatureConfig.field_202429_e);
        this.setRegistryName("quark", NAMESPACE);
    }

    public List<Biome.SpawnListEntry> func_202279_e() {
        return ENEMIES;
    }

    public boolean hasStartAt(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            int i = chunkPosX >> 4;
            int j = chunkPosZ >> 4;
            rand.setSeed((long)(i ^ j << 4) ^ chunkGen.func_202089_c());
            rand.nextInt();
            return rand.nextDouble() < BigDungeonModule.spawnChance;
        }
        return false;
    }

    protected int func_202382_c() {
        return 79234823;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return this.getRegistryName().toString();
    }

    public int func_202367_b() {
        return (int)Math.ceil((double)BigDungeonModule.maxRooms / 1.5);
    }

    static {
        BigDungeonChestProcessor chest = new BigDungeonChestProcessor();
        BigDungeonSpawnerProcessor spawn = new BigDungeonSpawnerProcessor();
        JigsawRegistryHelper.pool(NAMESPACE, STARTS_DIR).processor(chest, spawn).addMult(STARTS_DIR, STARTS, 1).register(JigsawPattern.PlacementBehaviour.RIGID);
        JigsawRegistryHelper.pool(NAMESPACE, ROOMS_DIR).processor(chest, spawn).addMult(ROOMS_DIR, ROOMS, 1).register(JigsawPattern.PlacementBehaviour.RIGID);
        JigsawRegistryHelper.pool(NAMESPACE, CORRIDORS_DIR).addMult(CORRIDORS_DIR, CORRIDORS, 1).register(JigsawPattern.PlacementBehaviour.RIGID);
        int roomWeight = 100;
        int corridorWeight = 120;
        double endpointWeightMult = 1.2;
        JigsawRegistryHelper.pool(NAMESPACE, "rooms_or_endpoint").processor(chest, spawn).addMult(ROOMS_DIR, ROOMS, 100).addMult(CORRIDORS_DIR, CORRIDORS, 120).add(ENDPOINT, (int)((double)(ROOMS.size() * 100 + CORRIDORS.size() * 120) * 1.2)).register(JigsawPattern.PlacementBehaviour.RIGID);
    }

    public static class Piece
    extends AbstractVillagePiece {
        public static IStructurePieceType PIECE_TYPE = (IStructurePieceType)Registry.func_218325_a((Registry)Registry.field_218362_C, (String)"bigdungeon", Piece::new);

        public Piece(TemplateManager templateManagerIn, JigsawPiece jigsawPieceIn, BlockPos posIn, int p_i50560_4_, Rotation rotationIn, MutableBoundingBox boundsIn) {
            super(PIECE_TYPE, templateManagerIn, jigsawPieceIn, posIn, p_i50560_4_, rotationIn, boundsIn);
        }

        public Piece(TemplateManager templateManagerIn, CompoundNBT nbt) {
            super(templateManagerIn, nbt, PIECE_TYPE);
        }
    }

    public static class Start
    extends MarginedStructureStart {
        public Start(Structure<?> structureIn, int chunkX, int chunkZ, MutableBoundingBox boundsIn, int referenceIn, long seed) {
            super(structureIn, chunkX, chunkZ, boundsIn, referenceIn, seed);
        }

        public void func_214625_a(ChunkGenerator<?> generator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            int shift;
            BlockPos blockpos = new BlockPos(chunkX * 16, 40, chunkZ * 16);
            JigsawManager.func_214889_a((ResourceLocation)START_POOL, (int)BigDungeonModule.maxRooms, Piece::new, generator, (TemplateManager)templateManagerIn, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
            int maxTop = 60;
            if (this.field_75074_b.field_78894_e >= maxTop) {
                shift = 5 + (this.field_75074_b.field_78894_e - maxTop);
                this.field_75074_b.func_78886_a(0, -shift, 0);
                this.field_75075_a.forEach(p -> p.func_181138_a(0, -shift, 0));
            }
            if (this.field_75074_b.field_78895_b < 6) {
                shift = 6 - this.field_75074_b.field_78895_b;
                this.field_75074_b.func_78886_a(0, shift, 0);
                this.field_75075_a.forEach(p -> p.func_181138_a(0, shift, 0));
            }
        }
    }
}

