/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gravestone")
public class BlockEvents {
    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.isCanceled()) {
            return;
        }
        IWorld world = event.getWorld();
        if (world.func_201670_d()) {
            return;
        }
        if (!event.getState().func_177230_c().equals(Main.GRAVESTONE)) {
            return;
        }
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (!(te instanceof GraveStoneTileEntity)) {
            return;
        }
        GraveStoneTileEntity graveTileEntity = (GraveStoneTileEntity)te;
        ItemStack stack = player.func_184614_ca();
        if (!(stack != null && stack.func_77973_b().equals(Main.GRAVESTONE_ITEM) || (stack = player.func_184592_cb()) != null && stack.func_77973_b().equals(Main.GRAVESTONE_ITEM))) {
            return;
        }
        if (!stack.func_82837_s()) {
            return;
        }
        String name = stack.func_200301_q().func_150261_e();
        if (name == null) {
            return;
        }
        graveTileEntity.setPlayerName(name);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        IWorld world = event.getWorld();
        if (world.func_201670_d()) {
            return;
        }
        if (!event.getState().func_177230_c().equals(Main.GRAVESTONE)) {
            return;
        }
        if (!this.checkBreak(event)) {
            return;
        }
        this.removeDeathNote(event);
        this.spawnGhost(event);
    }

    private void spawnGhost(BlockEvent.BreakEvent event) {
        if (!Config.spawnGhost) {
            return;
        }
        IWorld iWorld = event.getWorld();
        if (!(iWorld instanceof World)) {
            return;
        }
        World world = (World)iWorld;
        if (!world.func_175623_d(event.getPos().func_177984_a())) {
            return;
        }
        TileEntity te = world.func_175625_s(event.getPos());
        if (te == null || !(te instanceof GraveStoneTileEntity)) {
            return;
        }
        GraveStoneTileEntity tileentity = (GraveStoneTileEntity)te;
        UUID uuid = null;
        try {
            uuid = UUID.fromString(tileentity.getPlayerUUID());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uuid == null) {
            return;
        }
        GhostPlayerEntity ghost = new GhostPlayerEntity(world, uuid, tileentity.getPlayerName());
        ghost.func_70107_b((double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.1, (double)event.getPos().func_177952_p() + 0.5);
        world.func_217376_c((Entity)ghost);
    }

    private void removeDeathNote(BlockEvent.BreakEvent event) {
        if (!Config.removeDeathNote) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        PlayerInventory inv = player.field_71071_by;
        BlockPos pos = event.getPos();
        String dim = player.field_71093_bK.toString();
        for (ItemStack stack : inv.field_70462_a) {
            DeathInfo info;
            if (stack == null || !stack.func_77973_b().equals((Object)Main.DEATHINFO) || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("info") || (info = DeathInfo.fromNBT(stack.func_77978_p().func_74775_l("info"))) == null || !dim.equals(info.getDimension()) || !pos.equals((Object)info.getDeathLocation())) continue;
            inv.func_184437_d(stack);
        }
        for (ItemStack stack : inv.field_70460_b) {
            if (stack == null || !stack.func_77973_b().equals((Object)Main.DEATHINFO)) continue;
            inv.func_184437_d(stack);
        }
        for (ItemStack stack : inv.field_184439_c) {
            if (stack == null || !stack.func_77973_b().equals((Object)Main.DEATHINFO)) continue;
            inv.func_184437_d(stack);
        }
    }

    public boolean checkBreak(BlockEvent.BreakEvent event) {
        ServerPlayerEntity p;
        boolean isOp;
        if (!Config.onlyOwnersCanBreak) {
            return true;
        }
        IWorld world = event.getWorld();
        PlayerEntity player = event.getPlayer();
        TileEntity te = world.func_175625_s(event.getPos());
        if (te == null || !(te instanceof GraveStoneTileEntity)) {
            return true;
        }
        GraveStoneTileEntity tileentity = (GraveStoneTileEntity)te;
        if (player instanceof ServerPlayerEntity && (isOp = (p = (ServerPlayerEntity)player).func_211513_k(p.field_71133_b.func_110455_j()))) {
            return true;
        }
        String uuid = tileentity.getPlayerUUID();
        if (uuid == null) {
            return true;
        }
        if (player.func_110124_au().toString().equals(uuid)) {
            return true;
        }
        event.setCanceled(true);
        return false;
    }
}

