/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.gui;

import de.maxhenkel.gravestone.gui.DeathInfoScreen;
import de.maxhenkel.gravestone.util.Tools;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class Page {
    private ItemStack[] items;
    private DeathInfoScreen gui;

    public Page(ItemStack[] it, DeathInfoScreen gui) {
        this.gui = gui;
        int arraySize = 10;
        this.items = new ItemStack[10];
        if (it.length < 10) {
            arraySize = it.length;
        }
        for (int i = 0; i < this.items.length && i < arraySize; ++i) {
            this.items[i] = it[i];
        }
    }

    public void drawPage(int num) {
        String title = new TranslationTextComponent("gui.deathinfo.title.items", new Object[0]).func_150254_d();
        int titleWidth = this.gui.getFontRenderer().func_78256_a(title);
        this.gui.getFontRenderer().func_211126_b(TextFormatting.BLACK + "" + TextFormatting.UNDERLINE + title, (float)((this.gui.width - titleWidth) / 2), 30.0f, 0);
        String page = new TranslationTextComponent("gui.deathinfo.page", new Object[0]).func_150254_d();
        page = TextFormatting.DARK_GRAY + page + " " + TextFormatting.DARK_GRAY + String.valueOf(num);
        int pageWidth = this.gui.getFontRenderer().func_78256_a(page);
        this.gui.getFontRenderer().func_211126_b(page, (float)((this.gui.width - pageWidth) / 2), 43.0f, 0);
        int y = 60;
        int space = 12;
        for (int i = 0; i < this.items.length; ++i) {
            String name;
            ItemStack s = this.items[i];
            if (s == null || (name = Tools.translateItem(s)) == null) continue;
            this.gui.drawItem(TextFormatting.ITALIC + name, y);
            this.gui.drawItemSize(String.valueOf(s.func_190916_E()), y);
            y += 12;
        }
    }

    public String toString() {
        return Arrays.toString(this.items);
    }
}

