/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.classes.player;

import com.google.gson.annotations.JsonAdapter;
import com.maciej916.maessentials.classes.Storage;
import com.maciej916.maessentials.classes.home.HomeData;
import com.maciej916.maessentials.classes.player.EssentialPlayerSD;
import com.maciej916.maessentials.classes.player.PlayerData;
import com.maciej916.maessentials.classes.player.PlayerRestrictions;
import com.maciej916.maessentials.classes.player.PlayerTemp;
import com.maciej916.maessentials.classes.player.PlayerUsage;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.libs.Json;
import java.util.UUID;

@JsonAdapter(value=EssentialPlayerSD.class)
public class EssentialPlayer {
    private UUID playerUUID;
    private HomeData home_data = new HomeData();
    private PlayerData data = new PlayerData();
    private PlayerUsage last_usage = new PlayerUsage();
    private PlayerRestrictions restrictions = new PlayerRestrictions();
    private PlayerTemp temp_data = new PlayerTemp();
    private Storage custom_data = new Storage();

    public void setHomeData(HomeData home_data) {
        this.home_data = home_data;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public PlayerData getData() {
        return this.data;
    }

    public PlayerUsage getUsage() {
        return this.last_usage;
    }

    public PlayerRestrictions getRestrictions() {
        return this.restrictions;
    }

    public PlayerTemp getTemp() {
        return this.temp_data;
    }

    public Storage getCustomData() {
        return this.custom_data;
    }

    public HomeData getHomeData() {
        return this.home_data;
    }

    public EssentialPlayer(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public EssentialPlayer(UUID playerUUID, PlayerData data, PlayerRestrictions restrictions, PlayerUsage last_usage, Storage custom_data) {
        this.playerUUID = playerUUID;
        this.data = data;
        this.restrictions = restrictions;
        this.last_usage = last_usage;
        this.custom_data = custom_data;
    }

    public void cleanTemp() {
        this.temp_data = new PlayerTemp();
    }

    public void saveData() {
        Json.save(ConfigValues.worldCatalog + "players/", this.playerUUID.toString(), this);
    }

    public void saveHomes() {
        Json.save(ConfigValues.worldCatalog + "homes/", this.playerUUID.toString(), this.home_data);
    }
}

