/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.classes.player.PlayerRestriction;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.maciej916.maessentials.libs.Time;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class CommandCheck {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"check").requires(source -> source.func_197034_c(2))).then(Commands.func_197057_a((String)"bans").executes(context -> CommandCheck.bansCheck((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"mutes").executes(context -> CommandCheck.mutesCheck((CommandSource)context.getSource()))));
    }

    private static int bansCheck(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        HashMap<UUID, EssentialPlayer> players = DataManager.getPlayers();
        ArrayList<PlayerRestriction> restrictions = new ArrayList<PlayerRestriction>();
        for (Map.Entry<UUID, EssentialPlayer> entry : players.entrySet()) {
            EssentialPlayer eslPlayer = entry.getValue();
            PlayerRestriction restriction = eslPlayer.getRestrictions().getBan();
            if (!eslPlayer.getRestrictions().isRestricted(restriction)) continue;
            restrictions.add(restriction);
        }
        if (restrictions.size() > 0) {
            player.func_145747_a((ITextComponent)Methods.formatText("check.maessentials.player.banned.list", new Object[0]));
            for (PlayerRestriction restriction : restrictions) {
                if (restriction.getTime() == -1L) {
                    player.func_145747_a((ITextComponent)Methods.formatText("check.maessentials.player.banned.perm", player.func_145748_c_(), restriction.getReason()));
                    continue;
                }
                String displayTime = Time.formatDate(restriction.getTime() - Methods.currentTimestamp());
                player.func_145747_a((ITextComponent)Methods.formatText("check.maessentials.player.banned", player.func_145748_c_(), displayTime, restriction.getReason()));
            }
        } else {
            player.func_145747_a((ITextComponent)Methods.formatText("check.maessentials.player.banned.empty", new Object[0]));
        }
        return 1;
    }

    private static int mutesCheck(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        HashMap<UUID, EssentialPlayer> players = DataManager.getPlayers();
        ArrayList<PlayerRestriction> restrictions = new ArrayList<PlayerRestriction>();
        for (Map.Entry<UUID, EssentialPlayer> entry : players.entrySet()) {
            EssentialPlayer eslPlayer = entry.getValue();
            PlayerRestriction restriction = eslPlayer.getRestrictions().getMute();
            if (!eslPlayer.getRestrictions().isRestricted(restriction)) continue;
            restrictions.add(restriction);
        }
        if (restrictions.size() > 0) {
            player.func_145747_a((ITextComponent)Methods.formatText("check.maessentials.player.muted.list", new Object[0]));
            for (PlayerRestriction restriction : restrictions) {
                if (restriction.getTime() == -1L) {
                    player.func_145747_a((ITextComponent)Methods.formatText("check.maessentials.player.muted.perm", player.func_145748_c_(), restriction.getReason()));
                    continue;
                }
                String displayTime = Time.formatDate(restriction.getTime() - Methods.currentTimestamp());
                player.func_145747_a((ITextComponent)Methods.formatText("check.maessentials.player.muted", player.func_145748_c_(), displayTime, restriction.getReason()));
            }
        } else {
            player.func_145747_a((ITextComponent)Methods.formatText("check.maessentials.player.muted.empty", new Object[0]));
        }
        return 1;
    }
}

