/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.kit.Kit;
import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.maciej916.maessentials.libs.Time;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CommandKit {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"kit").requires(source -> source.func_197034_c(0));
        ((LiteralArgumentBuilder)builder.executes(context -> CommandKit.kit((CommandContext<CommandSource>)context))).then(Commands.func_197056_a((String)"kitName", (ArgumentType)StringArgumentType.word()).suggests(Methods.KIT_SUGGEST).executes(context -> CommandKit.kitArgs((CommandContext<CommandSource>)context)));
        dispatcher.register(builder);
        LiteralArgumentBuilder builder2 = (LiteralArgumentBuilder)Commands.func_197057_a((String)"kits").requires(source -> source.func_197034_c(0));
        builder2.executes(context -> CommandKit.kit((CommandContext<CommandSource>)context));
        dispatcher.register(builder2);
    }

    private static int kit(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        Set<String> kits = DataManager.getKit().getKits().keySet();
        TextComponent kitList = Methods.formatText("kit.maessentials.list", new Object[0]);
        if (kits.size() != 0) {
            int i = 1;
            for (String name : kits) {
                ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/kit " + name);
                HoverEvent eventHover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)Methods.formatText("kit.maessentials.list.kit", "/kit " + name));
                TextComponent kit = Methods.formatText("kit.maessentials.list.kit", name);
                kit.func_150256_b().func_150241_a(clickEvent);
                kit.func_150256_b().func_150209_a(eventHover);
                kitList.func_150257_a((ITextComponent)kit);
                if (kits.size() == i) continue;
                kitList.func_150257_a((ITextComponent)new StringTextComponent(", "));
                ++i;
            }
        } else {
            kitList.func_150257_a((ITextComponent)new StringTextComponent("-"));
        }
        player.func_145747_a((ITextComponent)kitList);
        return 1;
    }

    private static int kitArgs(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        String kitName = StringArgumentType.getString(context, (String)"kitName").toLowerCase();
        CommandKit.doKit(player, kitName);
        return 1;
    }

    private static void doKit(ServerPlayerEntity player, String name) {
        EssentialPlayer eslPlayer = DataManager.getPlayer(player);
        Kit kit = DataManager.getKit().getKit(name);
        if (kit == null) {
            player.func_145747_a((ITextComponent)Methods.formatText("kit.maessentials.not_exist", name));
            return;
        }
        long cooldown = eslPlayer.getUsage().getKitCooldown(name, kit.getDuration());
        if (cooldown != 0L) {
            String displayTime = Time.formatDate(cooldown);
            player.func_145747_a((ITextComponent)Methods.formatText("kit.maessentials.wait", displayTime));
            return;
        }
        if (Methods.giveKit(player, kit)) {
            eslPlayer.getUsage().setKitUssage(name);
            eslPlayer.saveData();
            player.field_70170_p.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.func_145747_a((ITextComponent)Methods.formatText("kit.maessentials.received", name));
        }
    }
}

