/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.commands;

import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.classes.player.PlayerRestriction;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Methods;
import com.maciej916.maessentials.libs.Time;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.MessageArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;

public class CommandMute {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"mute").requires(source -> source.func_197034_c(2));
        ((LiteralArgumentBuilder)builder.executes(context -> CommandMute.mute((CommandContext<CommandSource>)context))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targetPlayer", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> CommandMute.mutePlayer((CommandContext<CommandSource>)context))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"time", (ArgumentType)StringArgumentType.word()).executes(context -> CommandMute.mutePlayerTime((CommandContext<CommandSource>)context))).then(Commands.func_197056_a((String)"reason", (ArgumentType)MessageArgument.func_197123_a()).executes(context -> CommandMute.mutePlayerReason((CommandContext<CommandSource>)context)))));
        dispatcher.register(builder);
    }

    private static int mute(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        player.func_145747_a((ITextComponent)Methods.formatText("maessentials.provide.player", new Object[0]));
        return 1;
    }

    private static int mutePlayer(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        player.func_145747_a((ITextComponent)Methods.formatText("mute.maessentials.provide.time", new Object[0]));
        return 1;
    }

    private static int mutePlayerTime(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ServerPlayerEntity targetPlayer = EntityArgument.func_197089_d(context, (String)"targetPlayer");
        String time = StringArgumentType.getString(context, (String)"time");
        CommandMute.doMute(player, targetPlayer, time, "No reason provided");
        return 1;
    }

    private static int mutePlayerReason(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ServerPlayerEntity targetPlayer = EntityArgument.func_197089_d(context, (String)"targetPlayer");
        String time = StringArgumentType.getString(context, (String)"time").toLowerCase();
        ITextComponent reason = MessageArgument.func_197124_a(context, (String)"reason");
        CommandMute.doMute(player, targetPlayer, time, reason.getString());
        return 1;
    }

    private static void doMute(ServerPlayerEntity player, ServerPlayerEntity target, String time, String reason) {
        EssentialPlayer eslTargetPlayer = DataManager.getPlayer(target);
        PlayerRestriction mute = eslTargetPlayer.getRestrictions().getMute();
        long mutetime = Time.parseDate(time, true);
        if (time.equals("perm")) {
            mutetime = -1L;
        }
        if (mutetime == 0L) {
            player.func_145747_a((ITextComponent)Methods.formatText("maessentials.illegal_date", new Object[0]));
            return;
        }
        if (mute != null && (Methods.currentTimestamp() < mute.getTime() || mute.getTime() == -1L)) {
            player.func_145747_a((ITextComponent)Methods.formatText("mute.maessentials.already_muted", target.func_145748_c_()));
            return;
        }
        eslTargetPlayer.getRestrictions().setMute(mutetime, reason);
        eslTargetPlayer.saveData();
        if (mutetime == -1L) {
            player.field_71133_b.func_184103_al().func_148539_a((ITextComponent)Methods.formatText("mute.maessentials.success.perm", target.func_145748_c_(), player.func_145748_c_(), reason));
            target.func_145747_a((ITextComponent)Methods.formatText("mute.maessentials.success.perm.target", new Object[0]));
        } else {
            String displayTime = Time.formatDate(mutetime - Methods.currentTimestamp());
            player.field_71133_b.func_184103_al().func_148539_a((ITextComponent)Methods.formatText("mute.maessentials.success", target.func_145748_c_(), player.func_145748_c_(), displayTime, reason));
            target.func_145747_a((ITextComponent)Methods.formatText("mute.maessentials.success.target", displayTime));
        }
        target.func_145747_a((ITextComponent)Methods.formatText("mute.maessentials.success.target.reason", reason));
    }
}

