/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.data;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.maciej916.maessentials.MaEssentials;
import com.maciej916.maessentials.classes.Location;
import com.maciej916.maessentials.classes.home.HomeData;
import com.maciej916.maessentials.classes.kit.KitData;
import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.classes.warp.WarpData;
import com.maciej916.maessentials.classes.world.WorldData;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.data.old.OldProfile;
import com.maciej916.maessentials.data.old.OldWorld;
import com.maciej916.maessentials.data.old.ProfileUpdater;
import com.maciej916.maessentials.libs.Log;
import com.maciej916.maessentials.libs.Methods;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

public class DataLoader {
    public static void setupMain(FMLCommonSetupEvent event) {
        try {
            Log.log("Setup main");
            ConfigValues.mainCatalog = System.getProperty("user.dir") + "/" + "ma-essentials" + "/";
            Log.debug("Main catalog is: " + ConfigValues.mainCatalog);
            new File(ConfigValues.mainCatalog).mkdirs();
            File targetFile = new File(ConfigValues.mainCatalog + "default_kits.json");
            if (!targetFile.exists()) {
                Log.log("Creating default_kits.json in main catalog");
                InputStream initialStream = MaEssentials.class.getResourceAsStream("/default_kits.json");
                byte[] buffer = new byte[initialStream.available()];
                initialStream.read(buffer);
                FileOutputStream outStream = new FileOutputStream(targetFile);
                ((OutputStream)outStream).write(buffer);
            }
        }
        catch (Exception e) {
            Log.err("Error in setupMain");
            throw new Error(e);
        }
    }

    public static void setupWorld(FMLServerStartingEvent event) {
        try {
            Log.log("Setup world");
            if (event.getServer().func_71262_S()) {
                Log.log("Mod is running on server");
                ConfigValues.worldCatalog = ConfigValues.mainCatalog;
            } else {
                Log.log("Mod is running on client");
                ConfigValues.worldCatalog = System.getProperty("user.dir") + "/saves/" + event.getServer().func_71270_I() + "/" + "ma-essentials" + "/";
            }
            Log.debug("World catalog is: " + ConfigValues.worldCatalog);
            new File(ConfigValues.worldCatalog).mkdirs();
            new File(ConfigValues.worldCatalog + "homes").mkdirs();
            new File(ConfigValues.worldCatalog + "warps").mkdirs();
            new File(ConfigValues.worldCatalog + "players").mkdirs();
            if (!Methods.fileExist(ConfigValues.worldCatalog + "data.json")) {
                WorldInfo worldInfo = event.getServer().func_71218_a(DimensionType.func_186069_a((int)0)).func_72912_H();
                Location spawnLocation = new Location(worldInfo.func_76079_c(), worldInfo.func_76075_d(), worldInfo.func_76074_e(), 0);
                DataManager.getWorld().setSpawn(spawnLocation);
                DataManager.getWorld().saveData();
            }
            if (!Methods.fileExist(ConfigValues.worldCatalog + "kits.json")) {
                File def = new File(ConfigValues.mainCatalog + "default_kits.json");
                File des = new File(ConfigValues.worldCatalog + "kits.json");
                Files.copy(def.toPath(), des.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            Log.err("Error in setupWorld");
            throw new Error(e);
        }
    }

    public static void load() {
        Log.log("Loading data");
        try {
            Log.debug("Clean data");
            DataManager.cleanData();
            Log.debug("Loading world...");
            DataLoader.loadWorld();
            Log.debug("Loading warps...");
            DataLoader.loadWarps();
            Log.debug("Loading kits...");
            DataLoader.loadKits();
            Log.debug("Loading players...");
            DataLoader.loadPlayers();
            Log.debug("Loading homes...");
            DataLoader.loadHomes();
            Log.log("Data loaded");
        }
        catch (Exception e) {
            Log.err("Error while loading data!");
            throw new Error(e);
        }
    }

    private static void loadWorld() throws Exception {
        try {
            WorldData worldData = (WorldData)new Gson().fromJson((Reader)Methods.loadFile(ConfigValues.worldCatalog, "data"), WorldData.class);
            if (worldData.getSpawn() == null) {
                Log.debug("Failed to load new world data, fallback to old.");
                throw new Exception();
            }
            DataManager.setWorldData(worldData);
        }
        catch (Exception e) {
            Log.log("Updading world data.");
            OldWorld oldWorld = (OldWorld)new Gson().fromJson((Reader)Methods.loadFile(ConfigValues.worldCatalog, "data"), OldWorld.class);
            DataManager.getWorld().setSpawn(oldWorld.spawnLocation);
            DataManager.getWorld().saveData();
        }
    }

    private static void loadWarps() throws Exception {
        HashMap<String, Location> data = new HashMap<String, Location>();
        Methods.catalogFiles(ConfigValues.worldCatalog + "warps").forEach(n -> {
            try {
                Location warp = (Location)new Gson().fromJson((Reader)Methods.loadFile(ConfigValues.worldCatalog + "warps/", n), Location.class);
                data.put((String)n, warp);
            }
            catch (Exception e) {
                Log.err("Failed to load warp: " + n);
            }
        });
        WarpData warpData = new WarpData(data);
        DataManager.setWarpData(warpData);
    }

    private static void loadKits() throws Exception {
        try {
            KitData kitData = (KitData)new Gson().fromJson((Reader)Methods.loadFile(ConfigValues.worldCatalog, "kits"), KitData.class);
            DataManager.setKitData(kitData);
        }
        catch (JsonParseException ex) {
            Log.err("Failed to load kits!");
            Log.err(ex.toString());
        }
    }

    private static void loadPlayers() throws Exception {
        Methods.catalogFiles(ConfigValues.worldCatalog + "players").forEach(n -> {
            try {
                try {
                    EssentialPlayer eslPlayer = (EssentialPlayer)new Gson().fromJson((Reader)Methods.loadFile(ConfigValues.worldCatalog + "players/", n), EssentialPlayer.class);
                    if (eslPlayer.getPlayerUUID() == null) {
                        Log.debug("Failed to load using new player, fallback to old.");
                        throw new Exception();
                    }
                    DataManager.setPlayerData(eslPlayer);
                }
                catch (Exception e) {
                    Log.log("Updading player profile: " + n);
                    OldProfile oldProfile = (OldProfile)new Gson().fromJson((Reader)Methods.loadFile(ConfigValues.worldCatalog + "players/", n), OldProfile.class);
                    UUID playerUUID = UUID.fromString(n);
                    EssentialPlayer eslPlayer = ProfileUpdater.updateProfie(playerUUID, oldProfile);
                    eslPlayer.saveData();
                    DataManager.setPlayerData(eslPlayer);
                }
            }
            catch (Exception e) {
                Log.err("Failed to load player: " + n);
            }
        });
    }

    private static void loadHomes() throws Exception {
        Methods.catalogFiles(ConfigValues.worldCatalog + "homes").forEach(n -> {
            try {
                HomeData homes = (HomeData)new Gson().fromJson((Reader)Methods.loadFile(ConfigValues.worldCatalog + "homes/", n), HomeData.class);
                UUID playerUUID = UUID.fromString(n);
                DataManager.getPlayer(playerUUID).setHomeData(homes);
            }
            catch (Exception e) {
                Log.err("Failed to load player homes: " + n);
            }
        });
    }
}

