/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.libs;

import com.maciej916.maessentials.classes.Location;
import com.maciej916.maessentials.classes.player.EssentialPlayer;
import com.maciej916.maessentials.classes.teleport.TeleportRequest;
import com.maciej916.maessentials.classes.teleport.TeleportSimple;
import com.maciej916.maessentials.config.ConfigValues;
import com.maciej916.maessentials.data.DataManager;
import com.maciej916.maessentials.libs.Log;
import com.maciej916.maessentials.libs.Methods;
import java.util.ArrayList;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;

public class Teleport {
    private static ArrayList<TeleportSimple> teleportSimple = new ArrayList();
    private static ArrayList<TeleportRequest> teleportRequests = new ArrayList();

    static void doSimpleTeleport(TeleportSimple simple) {
        teleportSimple.add(simple);
    }

    static void doRequetTeleport(TeleportRequest request) {
        teleportRequests.add(request);
    }

    static TeleportRequest findRequest(ServerPlayerEntity creator, ServerPlayerEntity player, ServerPlayerEntity target) {
        for (TeleportRequest tp : teleportRequests) {
            if (tp.getCreator() != creator || tp.getPlayer() != player || tp.getTarget() != target) continue;
            return tp;
        }
        return null;
    }

    public static TeleportRequest findRequest(ServerPlayerEntity creator, ServerPlayerEntity target) {
        for (TeleportRequest tp : teleportRequests) {
            if ((tp.getCreator() != target || tp.getPlayer() != creator || tp.getTarget() != target) && (tp.getPlayer() != target || tp.getTarget() != creator)) continue;
            return tp;
        }
        return null;
    }

    public static ArrayList<TeleportRequest> findRequest(ServerPlayerEntity player) {
        ArrayList<TeleportRequest> found = new ArrayList<TeleportRequest>();
        for (TeleportRequest tp : teleportRequests) {
            if (tp.getPlayer() != player && tp.getTarget() != player) continue;
            found.add(tp);
        }
        return found;
    }

    public static void acceptRequest(TeleportRequest request) {
        if (request.getDelay() == 0L) {
            request.getPlayer().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.tpaccept.request", request.getTargetName()));
            request.getTarget().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.tpaccept.target", request.getPlayerName()));
            Teleport.doTeleport(request.getPlayer(), request.getDestination(), true, true);
            teleportRequests.remove(request);
        } else {
            request.getPlayer().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.tpaccept.request.wait", ConfigValues.tpa_delay));
            request.getTarget().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.tpaccept.target.wait", request.getPlayerName()));
            EssentialPlayer eslPlayer = DataManager.getPlayer(request.getPlayer());
            eslPlayer.getTemp().setTeleportActive(new Location(request.getPlayer()));
            request.setAccepted();
        }
    }

    public static void declineRequest(TeleportRequest request) {
        request.getPlayer().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.tpdeny.request", request.getTargetName()));
        request.getTarget().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.tpdeny.target", request.getPlayerName()));
        teleportRequests.remove(request);
    }

    public static void checkTeleports() {
        Teleport.checkSimple();
        if (ConfigValues.tpa_enable.booleanValue() || Methods.isDev()) {
            Teleport.checkRequest();
        }
    }

    private static void checkSimple() {
        ArrayList<TeleportSimple> del = new ArrayList<TeleportSimple>();
        for (TeleportSimple tp : teleportSimple) {
            EssentialPlayer eslPlayer;
            Location tpLocation;
            ServerPlayerEntity player = tp.getPlayer();
            Location playerLocation = new Location(player);
            if (Methods.checkLocation(playerLocation, tpLocation = (eslPlayer = DataManager.getPlayer(player)).getTemp().getTeleportLocation())) {
                if (Methods.currentTimestamp() < tp.getTeleportTime()) continue;
                player.func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.teleported", new Object[0]));
                eslPlayer.getTemp().setTeleportNotActive();
                eslPlayer.getUsage().setTeleportUsage(tp.getType());
                eslPlayer.saveData();
                Teleport.doTeleport(player, tp.getDestination(), true, true);
                del.add(tp);
                continue;
            }
            player.func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.moved", new Object[0]));
            eslPlayer.getTemp().setTeleportNotActive();
            del.add(tp);
        }
        teleportSimple.removeAll(del);
    }

    private static void checkRequest() {
        ArrayList<TeleportRequest> del = new ArrayList<TeleportRequest>();
        for (TeleportRequest tp : teleportRequests) {
            if (tp.isAccepted()) {
                EssentialPlayer eslPlayer;
                Location tpLocation;
                ServerPlayerEntity player = tp.getPlayer();
                Location playerLocation = new Location(player);
                if (Methods.checkLocation(playerLocation, tpLocation = (eslPlayer = DataManager.getPlayer(player)).getTemp().getTeleportLocation())) {
                    if (Methods.currentTimestamp() < tp.getTeleportTime()) continue;
                    tp.getPlayer().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.tpaccept.request", tp.getTargetName()));
                    tp.getTarget().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.tpaccept.target", tp.getPlayerName()));
                    eslPlayer.getTemp().setTeleportNotActive();
                    eslPlayer.getUsage().setTeleportUsage("tpa");
                    eslPlayer.saveData();
                    Teleport.doTeleport(tp.getPlayer(), new Location(tp.getTarget()), true, true);
                    del.add(tp);
                    continue;
                }
                tp.getPlayer().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.moved.request", new Object[0]));
                tp.getTarget().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.moved.target", tp.getPlayerName()));
                eslPlayer.getTemp().setTeleportNotActive();
                del.add(tp);
                continue;
            }
            if (Methods.currentTimestamp() < tp.getTimeout()) continue;
            tp.getPlayer().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.expired.target", tp.getTargetName()));
            tp.getTarget().func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.expired.request", tp.getPlayerName()));
            del.add(tp);
        }
        teleportRequests.removeAll(del);
    }

    public static void doTeleport(ServerPlayerEntity player, Location loc, boolean exact, boolean saveLastLocation) {
        try {
            if (saveLastLocation) {
                EssentialPlayer eslPlayer = DataManager.getPlayer(player);
                eslPlayer.getData().setLastLocation(new Location(player));
                eslPlayer.saveData();
            }
            ServerWorld worldDest = player.field_71133_b.func_71218_a(loc.getDimension());
            if (exact) {
                player.func_200619_a(worldDest, loc.x, loc.y, loc.z, loc.rotationYaw, loc.rotationPitch);
            } else {
                player.func_200619_a(worldDest, loc.x + 0.5, loc.y + 0.5, loc.z, player.field_70177_z, player.field_70125_A);
            }
        }
        catch (Exception e) {
            Log.err("Failed to do teleport for player " + player.func_145748_c_().getString() + ". Error: " + e.getMessage());
            player.func_145747_a((ITextComponent)Methods.formatText("teleport.maessentials.teleport.failed", new Object[0]));
        }
    }
}

