/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.libs;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Time {
    private static Pattern timePattern = Pattern.compile("(?:([0-9]+)\\s*y[a-z]*[,\\s]*)?(?:([0-9]+)\\s*mo[a-z]*[,\\s]*)?(?:([0-9]+)\\s*w[a-z]*[,\\s]*)?(?:([0-9]+)\\s*d[a-z]*[,\\s]*)?(?:([0-9]+)\\s*h[a-z]*[,\\s]*)?(?:([0-9]+)\\s*m[a-z]*[,\\s]*)?(?:([0-9]+)\\s*(?:s[a-z]*)?)?", 2);
    private static final int maxYears = 100000;

    public static long parseDate(String time, boolean future) {
        Matcher m = timePattern.matcher(time);
        int years = 0;
        int months = 0;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        boolean found = false;
        while (m.find()) {
            if (m.group() == null || m.group().isEmpty()) continue;
            for (int i = 0; i < m.groupCount(); ++i) {
                if (m.group(i) == null || m.group(i).isEmpty()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            if (m.group(1) != null && !m.group(1).isEmpty()) {
                years = Integer.parseInt(m.group(1));
            }
            if (m.group(2) != null && !m.group(2).isEmpty()) {
                months = Integer.parseInt(m.group(2));
            }
            if (m.group(3) != null && !m.group(3).isEmpty()) {
                weeks = Integer.parseInt(m.group(3));
            }
            if (m.group(4) != null && !m.group(4).isEmpty()) {
                days = Integer.parseInt(m.group(4));
            }
            if (m.group(5) != null && !m.group(5).isEmpty()) {
                hours = Integer.parseInt(m.group(5));
            }
            if (m.group(6) != null && !m.group(6).isEmpty()) {
                minutes = Integer.parseInt(m.group(6));
            }
            if (m.group(7) == null || m.group(7).isEmpty()) break;
            seconds = Integer.parseInt(m.group(7));
            break;
        }
        if (!found) {
            return 0L;
        }
        GregorianCalendar c = new GregorianCalendar();
        if (years > 0) {
            if (years > 100000) {
                years = 100000;
            }
            ((Calendar)c).add(1, years * (future ? 1 : -1));
        }
        if (months > 0) {
            ((Calendar)c).add(2, months * (future ? 1 : -1));
        }
        if (weeks > 0) {
            ((Calendar)c).add(3, weeks * (future ? 1 : -1));
        }
        if (days > 0) {
            ((Calendar)c).add(5, days * (future ? 1 : -1));
        }
        if (hours > 0) {
            ((Calendar)c).add(11, hours * (future ? 1 : -1));
        }
        if (minutes > 0) {
            ((Calendar)c).add(12, minutes * (future ? 1 : -1));
        }
        if (seconds > 0) {
            ((Calendar)c).add(13, seconds * (future ? 1 : -1));
        }
        GregorianCalendar max = new GregorianCalendar();
        ((Calendar)max).add(1, 10);
        if (c.after(max)) {
            return max.getTimeInMillis() / 1000L;
        }
        return c.getTimeInMillis() / 1000L;
    }

    public static String formatDate(long time) {
        long dy = TimeUnit.SECONDS.toDays(time);
        long yr = dy / 365L;
        long mn = (dy %= 365L) / 30L;
        long wk = (dy %= 30L) / 7L;
        dy %= 7L;
        long hr = TimeUnit.SECONDS.toHours(time) - TimeUnit.DAYS.toHours(TimeUnit.SECONDS.toDays(time));
        long min = TimeUnit.SECONDS.toMinutes(time) - TimeUnit.HOURS.toMinutes(TimeUnit.SECONDS.toHours(time));
        long sec = TimeUnit.SECONDS.toSeconds(time) - TimeUnit.MINUTES.toSeconds(TimeUnit.SECONDS.toMinutes(time));
        boolean now = false;
        String timeString = "";
        if (yr > 0L) {
            now = true;
            timeString = timeString + yr + " year(s)";
        }
        if (mn > 0L) {
            if (now) {
                timeString = timeString + " ";
            }
            now = true;
            timeString = timeString + mn + " month(s)";
        }
        if (wk > 0L) {
            if (now) {
                timeString = timeString + " ";
            }
            now = true;
            timeString = timeString + wk + " week(s)";
        }
        if (dy > 0L) {
            if (now) {
                timeString = timeString + " ";
            }
            now = true;
            timeString = timeString + dy + " day(s)";
        }
        if (hr > 0L) {
            if (now) {
                timeString = timeString + " ";
            }
            now = true;
            timeString = timeString + hr + " hour(s)";
        }
        if (min > 0L) {
            if (now) {
                timeString = timeString + " ";
            }
            now = true;
            timeString = timeString + min + " minute(s)";
        }
        if (sec > 0L) {
            if (now) {
                timeString = timeString + " ";
            }
            timeString = timeString + sec + " secoonds(s)";
        }
        return timeString;
    }
}

