/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public final class EntityBuilder<T extends Entity> {
    private final EntityType.IFactory<T> factory;
    private final EntityClassification classification;
    private boolean serializable;
    private boolean summonable;
    private boolean fireImmune;
    private boolean sendVelocityUpdates;
    private int trackingRange;
    private int updateInterval;
    private boolean ignoreSpawnRange;
    private EntitySize size;

    private EntityBuilder(EntityType.IFactory<T> factory, EntityClassification classification) {
        this.factory = factory;
        this.classification = classification;
        this.serializable = true;
        this.summonable = true;
        this.sendVelocityUpdates = true;
        this.trackingRange = 5;
        this.updateInterval = 3;
        this.ignoreSpawnRange = classification == EntityClassification.CREATURE || classification == EntityClassification.MISC;
        this.size = EntitySize.func_220314_b((float)0.6f, (float)1.8f);
    }

    public EntityBuilder<T> size(float width, float height) {
        this.size = EntitySize.func_220314_b((float)width, (float)height);
        return this;
    }

    public EntityBuilder<T> insummonable() {
        this.summonable = false;
        return this;
    }

    public EntityBuilder<T> unserializable() {
        this.serializable = false;
        return this;
    }

    public EntityBuilder<T> fireImmune() {
        this.fireImmune = true;
        return this;
    }

    public EntityBuilder<T> ignoreSpawnRange() {
        this.ignoreSpawnRange = true;
        return this;
    }

    public EntityBuilder<T> updateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
        return this;
    }

    public EntityBuilder<T> trackingRange(int trackingRange) {
        this.trackingRange = trackingRange;
        return this;
    }

    public EntityBuilder<T> sendVelocityUpdates(boolean sendVelocityUpdates) {
        this.sendVelocityUpdates = sendVelocityUpdates;
        return this;
    }

    public EntityType<T> build() {
        boolean sendVelocityUpdates = this.sendVelocityUpdates;
        int trackingRange = this.trackingRange;
        int updateInterval = this.updateInterval;
        return new EntityType<T>(this.factory, this.classification, this.serializable, this.summonable, this.fireImmune, this.ignoreSpawnRange, this.size, t -> sendVelocityUpdates, t -> trackingRange, t -> updateInterval, (msg, world) -> null){

            public T customClientSpawn(FMLPlayMessages.SpawnEntity msg, World world) {
                return this.func_200721_a(world);
            }
        };
    }

    public static <T extends Entity> EntityBuilder<T> create(EntityType.IFactory<T> factory, EntityClassification classification) {
        return new EntityBuilder<T>(factory, classification);
    }

    public static <T extends Entity> EntityBuilder<T> create(EntityClassification classification) {
        return new EntityBuilder<T>((type, world) -> null, classification);
    }
}

