/*
 * Decompiled with CFR 0.152.
 */
package de.mennomax.astikorcarts.world;

import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public interface AstikorWorld {
    public void addPulling(AbstractDrawnEntity var1);

    public Optional<AbstractDrawnEntity> getDrawn(Entity var1);

    public boolean isPulling(Entity var1);

    public void tick();

    public static LazyOptional<AstikorWorld> get(World world) {
        return world.getCapability(Capability.INSTANCE);
    }

    public static Stream<AstikorWorld> stream(World world) {
        return (Stream)world.getCapability(Capability.INSTANCE).map(Stream::of).orElse(Stream.empty());
    }

    public static ICapabilityProvider createProvider(final NonNullSupplier<AstikorWorld> factory) {
        return new ICapabilityProvider(){
            final LazyOptional<AstikorWorld> instance;
            {
                this.instance = LazyOptional.of((NonNullSupplier)factory);
            }

            public <T> LazyOptional<T> getCapability(net.minecraftforge.common.capabilities.Capability<T> cap, @Nullable Direction side) {
                return Capability.INSTANCE.orEmpty(cap, this.instance);
            }
        };
    }

    public static final class Capability {
        @CapabilityInject(value=AstikorWorld.class)
        private static net.minecraftforge.common.capabilities.Capability<AstikorWorld> INSTANCE;

        private Capability() {
        }
    }
}

