/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.network.NetworkHandler;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2561;

public class MetaDataProvider {
    public static int rateLimiter = 250;
    private Map<Integer, List<IComponentProvider>> headBlockProviders = new TreeMap<Integer, List<IComponentProvider>>();
    private Map<Integer, List<IComponentProvider>> bodyBlockProviders = new TreeMap<Integer, List<IComponentProvider>>();
    private Map<Integer, List<IComponentProvider>> tailBlockProviders = new TreeMap<Integer, List<IComponentProvider>>();
    private Map<Integer, List<IEntityComponentProvider>> headEntityProviders = new TreeMap<Integer, List<IEntityComponentProvider>>();
    private Map<Integer, List<IEntityComponentProvider>> bodyEntityProviders = new TreeMap<Integer, List<IEntityComponentProvider>>();
    private Map<Integer, List<IEntityComponentProvider>> tailEntityProviders = new TreeMap<Integer, List<IEntityComponentProvider>>();

    public void gatherBlockComponents(DataAccessor accessor, List<class_2561> tooltip, TooltipPosition position) {
        class_2248 block = accessor.getBlock();
        if (accessor.getBlockEntity() != null && accessor.isTimeElapsed(rateLimiter) && Waila.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
            accessor.resetTimer();
            if (WailaRegistrar.INSTANCE.hasNBTProviders(block) || WailaRegistrar.INSTANCE.hasNBTProviders(accessor.getBlockEntity())) {
                NetworkHandler.requestTile(accessor.getBlockEntity());
            }
        }
        this.headBlockProviders.clear();
        this.bodyBlockProviders.clear();
        this.tailBlockProviders.clear();
        if (position == TooltipPosition.HEAD && WailaRegistrar.INSTANCE.hasHeadProviders(block)) {
            this.headBlockProviders.putAll(WailaRegistrar.INSTANCE.getHeadProviders(block));
        } else if (position == TooltipPosition.BODY && WailaRegistrar.INSTANCE.hasBodyProviders(block)) {
            this.bodyBlockProviders.putAll(WailaRegistrar.INSTANCE.getBodyProviders(block));
        } else if (position == TooltipPosition.TAIL && WailaRegistrar.INSTANCE.hasTailProviders(block)) {
            this.tailBlockProviders.putAll(WailaRegistrar.INSTANCE.getTailProviders(block));
        }
        if (position == TooltipPosition.HEAD && WailaRegistrar.INSTANCE.hasHeadProviders(accessor.getBlockEntity())) {
            this.headBlockProviders.putAll(WailaRegistrar.INSTANCE.getHeadProviders(accessor.getBlockEntity()));
        } else if (position == TooltipPosition.BODY && WailaRegistrar.INSTANCE.hasBodyProviders(accessor.getBlockEntity())) {
            this.bodyBlockProviders.putAll(WailaRegistrar.INSTANCE.getBodyProviders(accessor.getBlockEntity()));
        } else if (position == TooltipPosition.TAIL && WailaRegistrar.INSTANCE.hasTailProviders(accessor.getBlockEntity())) {
            this.tailBlockProviders.putAll(WailaRegistrar.INSTANCE.getTailProviders(accessor.getBlockEntity()));
        }
        switch (position) {
            case HEAD: {
                for (List<IComponentProvider> providersList : this.headBlockProviders.values()) {
                    for (IComponentProvider dataProvider : providersList) {
                        try {
                            dataProvider.appendHead(tooltip, accessor, PluginConfig.INSTANCE);
                        }
                        catch (Throwable e) {
                            WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), tooltip);
                        }
                    }
                }
                break;
            }
            case BODY: {
                for (List<IComponentProvider> providersList : this.bodyBlockProviders.values()) {
                    for (IComponentProvider dataProvider : providersList) {
                        try {
                            dataProvider.appendBody(tooltip, accessor, PluginConfig.INSTANCE);
                        }
                        catch (Throwable e) {
                            WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), tooltip);
                        }
                    }
                }
                break;
            }
            case TAIL: {
                for (List<IComponentProvider> providersList : this.tailBlockProviders.values()) {
                    for (IComponentProvider dataProvider : providersList) {
                        try {
                            dataProvider.appendTail(tooltip, accessor, PluginConfig.INSTANCE);
                        }
                        catch (Throwable e) {
                            WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), tooltip);
                        }
                    }
                }
                break;
            }
        }
    }

    public void gatherEntityComponents(class_1297 entity, DataAccessor accessor, List<class_2561> tooltip, TooltipPosition position) {
        if (accessor.getEntity() != null && accessor.isTimeElapsed(rateLimiter)) {
            accessor.resetTimer();
            if (WailaRegistrar.INSTANCE.hasNBTEntityProviders(accessor.getEntity())) {
                NetworkHandler.requestEntity(accessor.getEntity());
            }
        }
        this.headEntityProviders.clear();
        this.bodyEntityProviders.clear();
        this.tailEntityProviders.clear();
        if (position == TooltipPosition.HEAD && WailaRegistrar.INSTANCE.hasHeadEntityProviders(entity)) {
            this.headEntityProviders.putAll(WailaRegistrar.INSTANCE.getHeadEntityProviders(entity));
        } else if (position == TooltipPosition.BODY && WailaRegistrar.INSTANCE.hasBodyEntityProviders(entity)) {
            this.bodyEntityProviders.putAll(WailaRegistrar.INSTANCE.getBodyEntityProviders(entity));
        } else if (position == TooltipPosition.TAIL && WailaRegistrar.INSTANCE.hasTailEntityProviders(entity)) {
            this.tailEntityProviders.putAll(WailaRegistrar.INSTANCE.getTailEntityProviders(entity));
        }
        switch (position) {
            case HEAD: {
                for (List<IEntityComponentProvider> providersList : this.headEntityProviders.values()) {
                    for (IEntityComponentProvider dataProvider : providersList) {
                        try {
                            dataProvider.appendHead(tooltip, accessor, PluginConfig.INSTANCE);
                        }
                        catch (Throwable e) {
                            WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), tooltip);
                        }
                    }
                }
                break;
            }
            case BODY: {
                for (List<IEntityComponentProvider> providersList : this.bodyEntityProviders.values()) {
                    for (IEntityComponentProvider dataProvider : providersList) {
                        try {
                            dataProvider.appendBody(tooltip, accessor, PluginConfig.INSTANCE);
                        }
                        catch (Throwable e) {
                            WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), tooltip);
                        }
                    }
                }
                break;
            }
            case TAIL: {
                for (List<IEntityComponentProvider> providersList : this.tailEntityProviders.values()) {
                    for (IEntityComponentProvider dataProvider : providersList) {
                        try {
                            dataProvider.appendTail(tooltip, accessor, PluginConfig.INSTANCE);
                        }
                        catch (Throwable e) {
                            WailaExceptionHandler.handleErr(e, dataProvider.getClass().toString(), tooltip);
                        }
                    }
                }
                break;
            }
        }
    }
}

