/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.network;

import io.netty.buffer.Unpooled;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.impl.WailaRegistrar;
import mcp.mobius.waila.api.impl.config.ConfigEntry;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import mcp.mobius.waila.network.ClientNetworkHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2680;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public class NetworkHandler {
    public static final class_2960 REQUEST_ENTITY = new class_2960("waila", "request_entity");
    public static final class_2960 REQUEST_TILE = new class_2960("waila", "request_tile");

    public static void init() {
        ServerSidePacketRegistry.INSTANCE.register(REQUEST_ENTITY, (packetContext, packetByteBuf) -> {
            class_1657 player = packetContext.getPlayer();
            class_1937 world = player.field_6002;
            class_1297 entity = world.method_8469(packetByteBuf.readInt());
            packetContext.getTaskQueue().execute(() -> {
                if (entity == null) {
                    return;
                }
                class_2487 tag = new class_2487();
                if (WailaRegistrar.INSTANCE.hasNBTEntityProviders(entity)) {
                    WailaRegistrar.INSTANCE.getNBTEntityProviders(entity).values().forEach(l -> l.forEach(p -> p.appendServerData(tag, (class_3222)player, world, (class_1309)entity)));
                } else {
                    entity.method_5647(tag);
                }
                tag.method_10569("WailaEntityID", entity.method_5628());
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.method_10794(tag);
                ((class_3222)player).field_13987.method_14364((class_2596)new class_2658(ClientNetworkHandler.RECEIVE_DATA, buf));
            });
        });
        ServerSidePacketRegistry.INSTANCE.register(REQUEST_TILE, (packetContext, packetByteBuf) -> {
            class_1657 player = packetContext.getPlayer();
            class_1937 world = player.field_6002;
            class_2338 pos = packetByteBuf.method_10811();
            packetContext.getTaskQueue().execute(() -> {
                if (!world.method_8393(pos.method_10263() >> 4, pos.method_10260() >> 4)) {
                    return;
                }
                class_2586 tile = world.method_8321(pos);
                if (tile == null) {
                    return;
                }
                class_2680 state = world.method_8320(pos);
                class_2487 tag = new class_2487();
                if (WailaRegistrar.INSTANCE.hasNBTProviders(tile) || WailaRegistrar.INSTANCE.hasNBTProviders(state.method_11614())) {
                    WailaRegistrar.INSTANCE.getNBTProviders(tile).values().forEach(l -> l.forEach(p -> p.appendServerData(tag, (class_3222)player, world, tile)));
                    WailaRegistrar.INSTANCE.getNBTProviders(state.method_11614()).values().forEach(l -> l.forEach(p -> p.appendServerData(tag, (class_3222)player, world, tile)));
                } else {
                    tile.method_11007(tag);
                }
                tag.method_10569("x", pos.method_10263());
                tag.method_10569("y", pos.method_10264());
                tag.method_10569("z", pos.method_10260());
                tag.method_10582("id", class_2378.field_11137.method_10221((Object)tile.method_11017()).toString());
                class_2540 buf = new class_2540(Unpooled.buffer());
                buf.method_10794(tag);
                ((class_3222)player).field_13987.method_14364((class_2596)new class_2658(ClientNetworkHandler.RECEIVE_DATA, buf));
            });
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void requestEntity(class_1297 entity) {
        if (class_310.method_1551().method_1562() == null) {
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(entity.method_5628());
        class_310.method_1551().method_1562().method_2872().method_10743((class_2596)new class_2817(REQUEST_ENTITY, buf));
    }

    @Environment(value=EnvType.CLIENT)
    public static void requestTile(class_2586 blockEntity) {
        if (class_310.method_1551().method_1562() == null) {
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(blockEntity.method_11016());
        class_310.method_1551().method_1562().method_2872().method_10743((class_2596)new class_2817(REQUEST_TILE, buf));
    }

    @Environment(value=EnvType.SERVER)
    public static void sendConfig(PluginConfig config, class_3222 player) {
        Waila.LOGGER.info("Sending config to {} ({})", (Object)player.method_7334().getName(), (Object)player.method_7334().getId());
        class_2540 buf = new class_2540(Unpooled.buffer());
        Set<ConfigEntry> entries = config.getSyncableConfigs();
        buf.writeInt(entries.size());
        entries.forEach(e -> {
            buf.writeInt(e.getId().toString().length());
            buf.method_10814(e.getId().toString());
            buf.writeBoolean(e.getValue());
        });
        player.field_13987.method_14364((class_2596)new class_2658(ClientNetworkHandler.GET_CONFIG, buf));
    }
}

