/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.overlay.IconUI;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4493;

public class DisplayUtil {
    private static final String[] NUM_SUFFIXES = new String[]{"", "k", "m", "b", "t"};
    private static final int MAX_LENGTH = 4;
    private static final class_310 CLIENT = class_310.method_1551();

    public static void renderStack(int x, int y, class_1799 stack) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.method_1480().method_4010(stack, x, y);
            class_1799 overlayRender = stack.method_7972();
            overlayRender.method_7939(1);
            CLIENT.method_1480().method_4025(DisplayUtil.CLIENT.field_1772, overlayRender, x, y);
            DisplayUtil.renderStackSize(DisplayUtil.CLIENT.field_1772, stack, x, y);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            WailaExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void renderStackSize(class_327 fr, class_1799 stack, int xPosition, int yPosition) {
        if (!stack.method_7960() && stack.method_7947() != 1) {
            String s = DisplayUtil.shortHandNumber(stack.method_7947());
            if (stack.method_7947() < 1) {
                s = class_124.field_1061 + String.valueOf(stack.method_7947());
            }
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.translated((double)0.0, (double)0.0, (double)(class_310.method_1551().method_1480().field_4730 + 200.0f));
            fr.method_1720(s, (float)(xPosition + 19 - 2 - fr.method_1727(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
        }
    }

    private static String shortHandNumber(Number number) {
        String shorthand = new DecimalFormat("##0E0").format(number);
        shorthand = shorthand.replaceAll("E[0-9]", NUM_SUFFIXES[Character.getNumericValue(shorthand.charAt(shorthand.length() - 1)) / 3]);
        while (shorthand.length() > 4 || shorthand.matches("[0-9]+\\.[a-z]")) {
            shorthand = shorthand.substring(0, shorthand.length() - 2) + shorthand.substring(shorthand.length() - 1);
        }
        return shorthand;
    }

    public static void enable3DRender() {
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float zLevel = 0.0f;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.blendFuncSeparate((class_4493.class_4535)class_4493.class_4535.SRC_ALPHA, (class_4493.class_4534)class_4493.class_4534.ONE_MINUS_SRC_ALPHA, (class_4493.class_4535)class_4493.class_4535.ONE, (class_4493.class_4534)class_4493.class_4534.ZERO);
        RenderSystem.shadeModel((int)7425);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(7, class_290.field_1576);
        buffer.method_22912((double)(left + right), (double)top, (double)zLevel).method_22915(f1, f2, f3, f).method_1344();
        buffer.method_22912((double)left, (double)top, (double)zLevel).method_22915(f1, f2, f3, f).method_1344();
        buffer.method_22912((double)left, (double)(top + bottom), (double)zLevel).method_22915(f5, f6, f7, f4).method_1344();
        buffer.method_22912((double)(left + right), (double)(top + bottom), (double)zLevel).method_22915(f5, f6, f7, f4).method_1344();
        tessellator.method_1350();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int tw, int th) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float zLevel = 0.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(7, class_290.field_1585);
        buffer.method_22912((double)x, (double)(y + height), (double)zLevel).method_22913((float)textureX * f, (float)(textureY + th) * f1).method_1344();
        buffer.method_22912((double)(x + width), (double)(y + height), (double)zLevel).method_22913((float)(textureX + tw) * f, (float)(textureY + th) * f1).method_1344();
        buffer.method_22912((double)(x + width), (double)y, (double)zLevel).method_22913((float)(textureX + tw) * f, (float)textureY * f1).method_1344();
        buffer.method_22912((double)x, (double)y, (double)zLevel).method_22913((float)textureX * f, (float)textureY * f1).method_1344();
        tessellator.method_1350();
    }

    public static List<class_2561> itemDisplayNameMultiline(class_1799 itemstack) {
        ArrayList<class_2561> namelist = null;
        try {
            namelist = itemstack.method_7950((class_1657)DisplayUtil.CLIENT.field_1724, (class_1836)class_1836.class_1837.field_8934);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (namelist == null) {
            namelist = new ArrayList<class_2561>();
        }
        if (namelist.isEmpty()) {
            namelist.add((class_2561)new class_2585("Unnamed"));
        }
        namelist.set(0, (class_2561)new class_2585(itemstack.method_7932().field_8908.toString() + namelist.get(0)));
        for (int i = 1; i < namelist.size(); ++i) {
            namelist.set(i, (class_2561)namelist.get(i));
        }
        return namelist;
    }

    public static String itemDisplayNameShort(class_1799 itemstack) {
        List<class_2561> list = DisplayUtil.itemDisplayNameMultiline(itemstack);
        return String.format(Waila.CONFIG.get().getFormatting().getBlockName(), list.get(0).method_10863());
    }

    public static void renderIcon(int x, int y, int sx, int sy, IconUI icon) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CLIENT.method_1531().method_22813(class_332.GUI_ICONS_LOCATION);
        if (icon == null) {
            return;
        }
        RenderSystem.enableAlphaTest();
        if (icon.bu != -1) {
            DisplayUtil.drawTexturedModalRect(x, y, icon.bu, icon.bv, sx, sy, icon.bsu, icon.bsv);
        }
        DisplayUtil.drawTexturedModalRect(x, y, icon.u, icon.v, sx, sy, icon.su, icon.sv);
        RenderSystem.disableAlphaTest();
    }
}

