/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.RenderableTextComponent;
import mcp.mobius.waila.api.event.WailaTooltipEvent;
import mcp.mobius.waila.api.impl.DataAccessor;
import mcp.mobius.waila.api.impl.TaggableList;
import mcp.mobius.waila.api.impl.TaggedTextComponent;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.overlay.RayTracing;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class Tooltip {
    private final class_310 client;
    private final List<Line> lines;
    private final boolean showItem;
    private final Dimension totalSize;

    public Tooltip(List<class_2561> Texts, boolean showItem) {
        WailaTooltipEvent event = new WailaTooltipEvent(Texts, DataAccessor.INSTANCE);
        ((WailaTooltipEvent.HandleTooltip)WailaTooltipEvent.WAILA_HANDLE_TOOLTIP.invoker()).onTooltip(event);
        this.client = class_310.method_1551();
        this.lines = Lists.newArrayList();
        this.showItem = showItem;
        this.totalSize = new Dimension();
        this.computeLines(Texts);
        this.addPadding();
    }

    public void computeLines(List<class_2561> Texts) {
        Texts.forEach(c -> {
            Dimension size = this.getLineSize((class_2561)c, Texts);
            this.totalSize.setSize(Math.max(this.totalSize.width, size.width), this.totalSize.height + size.height);
            class_2561 Text = c;
            if (Text instanceof TaggedTextComponent) {
                Text = (class_2561)((ITaggableList)Texts).getTag(((TaggedTextComponent)Text).getTag());
            }
            this.lines.add(new Line(Text, size));
        });
    }

    public void addPadding() {
        this.totalSize.width = this.totalSize.width + (this.hasItem() ? 30 : 10);
        this.totalSize.height += 8;
    }

    public void draw() {
        Rectangle position = this.getPosition();
        WailaConfig.ConfigOverlay.ConfigOverlayColor color = Waila.CONFIG.get().getOverlay().getColor();
        position.x = position.x + (this.hasItem() ? 26 : 6);
        position.width = position.width + (this.hasItem() ? 24 : 4);
        position.y += 6;
        for (Line line : this.lines) {
            if (line.getText() instanceof RenderableTextComponent) {
                RenderableTextComponent Text = (RenderableTextComponent)line.getText();
                int xOffset = 0;
                for (RenderableTextComponent.RenderContainer container : Text.getRenderers()) {
                    Dimension size = container.getRenderer().getSize(container.getData(), DataAccessor.INSTANCE);
                    container.getRenderer().draw(container.getData(), DataAccessor.INSTANCE, position.x + xOffset, position.y);
                    xOffset += size.width;
                }
            } else {
                this.client.field_1772.method_1720(line.getText().method_10863(), (float)position.x, (float)position.y, color.getFontColor());
            }
            position.y += ((Line)line).size.height;
        }
    }

    private Dimension getLineSize(class_2561 text, List<class_2561> texts) {
        if (text instanceof RenderableTextComponent) {
            RenderableTextComponent renderable = (RenderableTextComponent)text;
            List<RenderableTextComponent.RenderContainer> renderers = renderable.getRenderers();
            if (renderers.isEmpty()) {
                return new Dimension(0, 0);
            }
            int width = 0;
            int height = 0;
            for (RenderableTextComponent.RenderContainer container : renderers) {
                Dimension iconSize = container.getRenderer().getSize(container.getData(), DataAccessor.INSTANCE);
                width += iconSize.width;
                height = Math.max(height, iconSize.height);
            }
            return new Dimension(width, height);
        }
        if (text instanceof TaggedTextComponent) {
            TaggedTextComponent tagged = (TaggedTextComponent)text;
            if (texts instanceof TaggableList) {
                class_2561 taggedLine = (class_2561)((TaggableList)texts).getTag(tagged.getTag());
                return taggedLine == null ? new Dimension(0, 0) : this.getLineSize(taggedLine, texts);
            }
        }
        int n = this.client.field_1772.method_1727(text.method_10863());
        this.client.field_1772.getClass();
        return new Dimension(n, 9 + 1);
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public boolean hasItem() {
        return this.showItem && Waila.CONFIG.get().getGeneral().shouldShowItem() && !RayTracing.INSTANCE.getIdentifierStack().method_7960();
    }

    public Rectangle getPosition() {
        class_1041 window = class_310.method_1551().method_22683();
        return new Rectangle((int)((float)window.method_4486() * Waila.CONFIG.get().getOverlay().getOverlayPosX() - (float)(this.totalSize.width / 2)), (int)((float)window.method_4502() * (1.0f - Waila.CONFIG.get().getOverlay().getOverlayPosY())), this.totalSize.width, this.totalSize.height);
    }

    public static class Line {
        private final class_2561 Text;
        private final Dimension size;

        public Line(class_2561 Text, Dimension size) {
            this.Text = Text;
            this.size = size;
        }

        public class_2561 getText() {
            return this.Text;
        }

        public Dimension getSize() {
            return this.size;
        }
    }
}

