/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.network;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import squeek.appleskin.helpers.HungerHelper;

public class SyncHandler {
    private static final class_2960 EXHAUSTION_SYNC = new class_2960("appleskin", "exhaustion_sync");
    private static final class_2960 SATURATION_SYNC = new class_2960("appleskin", "saturation_sync");
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();

    @Environment(value=EnvType.CLIENT)
    public static void init() {
        ClientSidePacketRegistry.INSTANCE.register(EXHAUSTION_SYNC, (packetContext, packetByteBuf) -> {
            float exhaustion = packetByteBuf.readFloat();
            class_310.method_1551().execute(() -> HungerHelper.setExhaustion(packetContext.getPlayer(), exhaustion));
        });
        ClientSidePacketRegistry.INSTANCE.register(SATURATION_SYNC, (packetContext, packetByteBuf) -> {
            float saturation = packetByteBuf.readFloat();
            class_310.method_1551().execute(() -> packetContext.getPlayer().method_7344().method_7581(saturation));
        });
    }

    private static class_2658 makeSyncPacket(class_2960 identifier, float val) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeFloat(val);
        return new class_2658(identifier, buf);
    }

    public static void onPlayerUpdate(class_3222 player) {
        Float lastSaturationLevel = lastSaturationLevels.get(player.method_5667());
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.method_5667());
        float saturation = player.method_7344().method_7589();
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != saturation) {
            player.field_13987.method_14364((class_2596)SyncHandler.makeSyncPacket(SATURATION_SYNC, saturation));
            lastSaturationLevels.put(player.method_5667(), Float.valueOf(saturation));
        }
        float exhaustionLevel = HungerHelper.getExhaustion((class_1657)player);
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            player.field_13987.method_14364((class_2596)SyncHandler.makeSyncPacket(EXHAUSTION_SYNC, exhaustionLevel));
            lastExhaustionLevels.put(player.method_5667(), Float.valueOf(exhaustionLevel));
        }
    }

    public static void onPlayerLoggedIn(class_3222 player) {
        lastSaturationLevels.remove(player.method_5667());
        lastExhaustionLevels.remove(player.method_5667());
    }
}

